/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.deployments;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.spi.api.DefaultDeploymentFactory;

@ApplicationScoped
public class DefaultDeploymentCreator {
    private Map<String, DefaultDeploymentFactory> factories = new HashMap<String, DefaultDeploymentFactory>();

    @Inject
    public DefaultDeploymentCreator(@Any Instance<DefaultDeploymentFactory> factories) {
        this((Iterable<DefaultDeploymentFactory>)factories);
    }

    public DefaultDeploymentCreator(DefaultDeploymentFactory ... factories) {
        this(Arrays.asList(factories));
    }

    public DefaultDeploymentCreator(Iterable<DefaultDeploymentFactory> factories) {
        for (DefaultDeploymentFactory factory : factories) {
            DefaultDeploymentFactory current = this.factories.get(factory.getType());
            if (current == null) {
                this.factories.put(factory.getType(), factory);
                continue;
            }
            if (factory.getPriority() <= current.getPriority()) continue;
            this.factories.put(factory.getType(), factory);
        }
    }

    public Archive<?> createDefaultDeployment(String type) {
        DefaultDeploymentFactory factory = this.getFactory(type);
        if (factory == null) {
            return null;
        }
        try {
            return factory.create();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    DefaultDeploymentFactory getFactory(String type) {
        return this.factories.get(type);
    }
}

