/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.internal.SwarmConfigMessages;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.runtime.ConfigurationMarshaller;

@ApplicationScoped
public class ConfigViewPropertyMarshaller
implements ConfigurationMarshaller {
    @Inject
    private ConfigView configView;

    public void marshal(List<ModelNode> list) {
        Properties properties = this.configView.asProperties();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String value;
            String key = (String)names.nextElement();
            if (key.startsWith("jboss") || key.startsWith("java") || (value = properties.getProperty(key)) == null) continue;
            SwarmConfigMessages.MESSAGES.marshalProjectStageProperty(key);
            ModelNode modelNode = new ModelNode();
            modelNode.get("operation").set("add");
            modelNode.get("address").set("system-property", key);
            modelNode.get("value").set(properties.getProperty(key));
            list.add(modelNode);
        }
    }
}

