/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;

public class MavenArgsParser {
    private Map<ARG, String> argValues = new HashMap<ARG, String>();

    private MavenArgsParser(String commandLine) {
        StringTokenizer tok = new StringTokenizer(commandLine, " ");
        while (tok.hasMoreTokens()) {
            ARG[] args;
            String token = tok.nextToken();
            for (ARG arg : args = ARG.values()) {
                Optional<String> irregularValue = this.parseIrregularSyntax(arg, token);
                if (irregularValue.isPresent()) {
                    this.argValues.put(arg, irregularValue.get());
                    continue;
                }
                if (token.equals(arg.flag) && tok.hasMoreTokens()) {
                    this.argValues.put(arg, tok.nextToken());
                    continue;
                }
                if (!token.equals(arg.altFlag) || !tok.hasMoreTokens()) continue;
                this.argValues.put(arg, tok.nextToken());
            }
        }
    }

    private Optional<String> parseIrregularSyntax(ARG arg, String token) {
        Optional<String> result = Optional.empty();
        if (token.startsWith(arg.flag) && token.length() > arg.flag.length()) {
            if (arg.suffix != null && !token.endsWith(arg.suffix)) {
                return result;
            }
            result = Optional.of(token.substring(token.indexOf(arg.flag) + arg.flag.length()));
        }
        return result;
    }

    public Optional<String> get(ARG arg) {
        return this.argValues.containsKey((Object)arg) ? Optional.of(this.argValues.get((Object)arg)) : Optional.empty();
    }

    public static MavenArgsParser parse(String commandLine) {
        if (null == commandLine) {
            throw new IllegalArgumentException("commandLine cannot be null");
        }
        return new MavenArgsParser(commandLine);
    }

    public static enum ARG {
        F("-f", "--file", ".xml"),
        P("-P", "--activate-profiles", null);

        private final String flag;
        private final String altFlag;
        private final String suffix;

        private ARG(String flag, String altFlag, String suffix) {
            this.flag = flag;
            this.altFlag = altFlag;
            this.suffix = suffix;
        }

        public String getFlag() {
            return this.flag;
        }

        public String getAltFlag() {
            return this.altFlag;
        }
    }
}

