/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.container.config.ConfigNode;
import org.wildfly.swarm.spi.api.config.ConfigKey;

@Vetoed
public class EnvironmentConfigNodeFactory {
    private EnvironmentConfigNodeFactory() {
    }

    public static ConfigNode load(Map<String, String> input) {
        ConfigNode config = new ConfigNode();
        EnvironmentConfigNodeFactory.load(config, input);
        return config;
    }

    protected static void load(ConfigNode config, Map<String, String> input) {
        Set<String> names = input.keySet();
        for (String name : names) {
            String after = EnvironmentConfigNodeFactory.normalizeName(name);
            if (!after.startsWith("swarm.") && !after.startsWith("thorntail.")) continue;
            String value = input.get(name);
            ConfigKey key = ConfigKey.parse((String)after);
            config.recursiveChild(key, (Object)value);
        }
    }

    protected static String normalizeName(String key) {
        key = key.replace("_DASH_", "-");
        key = key.replace("_UNDERSCORE_", "---");
        key = key.replace('_', '.');
        key = key.replace("---", "_");
        key = key.toLowerCase();
        return key;
    }
}

