/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi.configurable;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContext;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;

@ApplicationScoped
public class DeploymentProducer {
    private static final Logger LOGGER = Logger.getLogger((String)"org.wildfly.swarm.deployment");
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    static final String INDEX_LOCATION = "META-INF/jandex.idx";
    @Inject
    DeploymentContext context;

    @Produces
    @DeploymentScoped
    Archive archive() {
        return this.context.getCurrentArchive();
    }

    @Produces
    @DeploymentScoped
    IndexView index() {
        return this.createDeploymentIndex(this.context.getCurrentArchive());
    }

    IndexView createDeploymentIndex(Archive<?> deployment) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        try {
            this.index(deployment, indexes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return CompositeIndex.create(indexes);
    }

    private void index(Archive<?> archive, List<IndexView> indexes) throws IOException {
        LOGGER.debugv("Indexing archive: {0}", (Object)archive.getName());
        Node indexNode = archive.get(ArchivePaths.create((String)INDEX_LOCATION));
        if (indexNode != null) {
            InputStream indexStream = indexNode.getAsset().openStream();
            Object object = null;
            try {
                LOGGER.debugv("Loading attached index from archive: {0}", (Object)archive.getName());
                indexes.add((IndexView)new IndexReader(indexStream).read());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (indexStream != null) {
                    if (object != null) {
                        try {
                            indexStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        indexStream.close();
                    }
                }
            }
        }
        Indexer indexer = new Indexer();
        for (Map.Entry entry : archive.getContent(this::isClass).entrySet()) {
            try {
                InputStream contentStream = ((Node)entry.getValue()).getAsset().openStream();
                Throwable throwable = null;
                try {
                    LOGGER.debugv("Indexing asset: {0} from archive: {1}", (Object)((ArchivePath)entry.getKey()).get(), (Object)archive.getName());
                    indexer.index(contentStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
            catch (IOException indexerIOException) {
                LOGGER.warnv((Throwable)indexerIOException, "Failed parsing: {0} from archive: {1}", (Object)((ArchivePath)entry.getKey()).get(), (Object)archive.getName());
            }
        }
        Index index = indexer.complete();
        indexes.add((IndexView)index);
        if (archive instanceof LibraryContainer) {
            for (Map.Entry entry : archive.getContent(a -> a.get().endsWith(JAR_SUFFIX)).entrySet()) {
                if (((Node)entry.getValue()).getAsset() instanceof ArchiveAsset) {
                    ArchiveAsset archiveAsset = (ArchiveAsset)((Node)entry.getValue()).getAsset();
                    this.index(archiveAsset.getArchive(), indexes);
                    continue;
                }
                InputStream inputStream = ((Node)entry.getValue()).getAsset().openStream();
                Throwable throwable = null;
                try {
                    JARArchive jarArchive = (JARArchive)((ZipImporter)((ZipImporter)((JARArchive)ShrinkWrap.create(JARArchive.class, (String)((ArchivePath)entry.getKey()).get())).as(ZipImporter.class)).importFrom(inputStream)).as(JARArchive.class);
                    this.index((Archive<?>)jarArchive, indexes);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    private boolean isClass(ArchivePath a) {
        String path = a.get();
        return path.endsWith(CLASS_SUFFIX) && !path.endsWith("module-info.class");
    }
}

