/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.SimpleKey;

@ApplicationScoped
public class ArtifactDeployer {
    @Inject
    ConfigView configView;
    @Inject
    private Instance<RuntimeDeployer> deployer;

    public void deploy() throws Exception {
        List subkeys = this.configView.simpleSubkeys(ConfigKey.of((String[])new String[]{"thorntail", "deployment"}));
        for (SimpleKey subkey : subkeys) {
            String packaging;
            String artifactId;
            String spec = subkey.name();
            if (!spec.contains(":")) continue;
            String[] parts = spec.split(":");
            String groupId = parts[0];
            int p = parts[1].lastIndexOf(46);
            if (p == -1) {
                artifactId = parts[1];
                packaging = "jar";
            } else {
                artifactId = parts[1].substring(0, p);
                packaging = parts[1].substring(p + 1);
            }
            JavaArchive artifact = Swarm.artifact(groupId + ":" + artifactId + ":" + packaging + ":*", artifactId + "." + packaging);
            ((RuntimeDeployer)this.deployer.get()).deploy((Archive<?>)artifact, spec);
        }
    }
}

