/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractions;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.swarm.fractions.FractionDescriptor;
import org.wildfly.swarm.fractions.FractionListParser;

public class FractionList {
    private final FractionListParser fractionListParser;
    private static final AtomicReference<FractionList> INSTANCE = new AtomicReference();

    public static FractionList get() {
        return INSTANCE.updateAndGet(old -> old != null ? old : new FractionList());
    }

    private FractionList() {
        try (InputStream fractionJsonStream = this.getClass().getClassLoader().getResourceAsStream("fraction-list.json");){
            this.fractionListParser = new FractionListParser(fractionJsonStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<FractionDescriptor> getFractionDescriptors() {
        return this.fractionListParser.getFractionDescriptors();
    }

    public FractionDescriptor getFractionDescriptor(String groupId, String artifactId) {
        return this.fractionListParser.getFractionDescriptor(groupId, artifactId);
    }
}

