/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.wildfly.swarm.internal.ExplodedApplicationArtifactLocator;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.spi.api.DefaultDeploymentFactory;
import org.wildfly.swarm.spi.api.DependenciesContainer;
import org.wildfly.swarm.undertow.WARArchive;

@ApplicationScoped
public class DefaultWarDeploymentFactory
extends DefaultDeploymentFactory {
    public static final ArchivePath MARKER_PATH = ArchivePaths.create((String)("META-INF/" + DefaultWarDeploymentFactory.class.getName()));

    public static WARArchive archiveFromCurrentApp() throws Exception {
        WARArchive archive = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)DefaultWarDeploymentFactory.determineName());
        DefaultWarDeploymentFactory factory = new DefaultWarDeploymentFactory();
        factory.setup(archive);
        archive.add((Asset)EmptyAsset.INSTANCE, MARKER_PATH);
        return archive;
    }

    public int getPriority() {
        return 0;
    }

    public String getType() {
        return "war";
    }

    public Archive create() throws Exception {
        return DefaultWarDeploymentFactory.archiveFromCurrentApp().staticContent();
    }

    public boolean setupUsingMaven(Archive<?> givenArchive) throws Exception {
        Path webapp;
        Path resources;
        final DependenciesContainer archive = (DependenciesContainer)givenArchive;
        FileSystemLayout fsLayout = FileSystemLayout.create();
        Path classes = fsLayout.resolveBuildClassesDir();
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            this.addFilesToArchive(classes, archive);
        }
        if (!Files.isSameFile(resources = fsLayout.resolveBuildResourcesDir(), classes) && Files.exists(resources, new LinkOption[0])) {
            success = true;
            this.addFilesToArchive(resources, archive);
        }
        if (Files.exists(webapp = fsLayout.resolveSrcWebAppDir(), new LinkOption[0])) {
            success = true;
            Files.walkFileTree(webapp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = webapp.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeploymentFactory.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        archive.addAllDependencies();
        return success;
    }

    protected boolean setupUsingAppArtifact(Archive<?> archive) throws IOException {
        File exploded = ExplodedApplicationArtifactLocator.get();
        if (exploded != null && exploded.canRead()) {
            ((ExplodedImporter)archive.as(ExplodedImporter.class)).importDirectory(exploded);
            return true;
        }
        return super.setupUsingAppArtifact(archive);
    }

    private void addFilesToArchive(final Path files, final DependenciesContainer<?> archive) throws Exception {
        Files.walkFileTree(files, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path simple = files.relativize(file);
                archive.add((Asset)new FileAsset(file.toFile()), "WEB-INF/classes/" + DefaultWarDeploymentFactory.this.convertSeparators(simple));
                if (simple.toString().contains("WEB-INF")) {
                    archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeploymentFactory.this.convertSeparators(simple));
                }
                return super.visitFile(file, attrs);
            }
        });
    }

    protected static String determineName() {
        return DefaultDeploymentFactory.determineName((String)".war");
    }
}

