/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonObject
extends Expression {
    private final List<JsonObjectMember> members;
    private final boolean nullOnNull;
    private final boolean uniqueKeys;
    private final Optional<DataType> returnedType;
    private final Optional<JsonPathParameter.JsonFormat> outputFormat;

    public JsonObject(Optional<NodeLocation> location, List<JsonObjectMember> members, boolean nullOnNull, boolean uniqueKeys, Optional<DataType> returnedType, Optional<JsonPathParameter.JsonFormat> outputFormat) {
        super(location);
        Objects.requireNonNull(members, "members is null");
        Objects.requireNonNull(returnedType, "returnedType is null");
        Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.members = ImmutableList.copyOf(members);
        this.nullOnNull = nullOnNull;
        this.uniqueKeys = uniqueKeys;
        this.returnedType = returnedType;
        this.outputFormat = outputFormat;
    }

    public List<JsonObjectMember> getMembers() {
        return this.members;
    }

    public boolean isNullOnNull() {
        return this.nullOnNull;
    }

    public boolean isUniqueKeys() {
        return this.uniqueKeys;
    }

    public Optional<DataType> getReturnedType() {
        return this.returnedType;
    }

    public Optional<JsonPathParameter.JsonFormat> getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonObject(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.members;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject that = (JsonObject)o;
        return Objects.equals(this.members, that.members) && this.nullOnNull == that.nullOnNull && this.uniqueKeys == that.uniqueKeys && Objects.equals(this.returnedType, that.returnedType) && Objects.equals(this.outputFormat, that.outputFormat);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.members, this.nullOnNull, this.uniqueKeys, this.returnedType, this.outputFormat);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonObject.sameClass(this, other)) {
            return false;
        }
        JsonObject that = (JsonObject)other;
        return this.nullOnNull == that.nullOnNull && this.uniqueKeys == that.uniqueKeys && Objects.equals(this.returnedType, that.returnedType) && Objects.equals(this.outputFormat, that.outputFormat);
    }
}

