/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryColumn
extends JsonTableColumnDefinition {
    private final Identifier name;
    private final DataType type;
    private final JsonPathParameter.JsonFormat format;
    private final Optional<StringLiteral> jsonPath;
    private final JsonQuery.ArrayWrapperBehavior wrapperBehavior;
    private final Optional<JsonQuery.QuotesBehavior> quotesBehavior;
    private final JsonQuery.EmptyOrErrorBehavior emptyBehavior;
    private final Optional<JsonQuery.EmptyOrErrorBehavior> errorBehavior;

    public QueryColumn(NodeLocation location, Identifier name, DataType type, JsonPathParameter.JsonFormat format, Optional<StringLiteral> jsonPath, JsonQuery.ArrayWrapperBehavior wrapperBehavior, Optional<JsonQuery.QuotesBehavior> quotesBehavior, JsonQuery.EmptyOrErrorBehavior emptyBehavior, Optional<JsonQuery.EmptyOrErrorBehavior> errorBehavior) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.format = Objects.requireNonNull(format, "format is null");
        this.jsonPath = Objects.requireNonNull(jsonPath, "jsonPath is null");
        this.wrapperBehavior = Objects.requireNonNull(wrapperBehavior, "wrapperBehavior is null");
        this.quotesBehavior = Objects.requireNonNull(quotesBehavior, "quotesBehavior is null");
        this.emptyBehavior = Objects.requireNonNull(emptyBehavior, "emptyBehavior is null");
        this.errorBehavior = Objects.requireNonNull(errorBehavior, "errorBehavior is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public JsonPathParameter.JsonFormat getFormat() {
        return this.format;
    }

    public Optional<StringLiteral> getJsonPath() {
        return this.jsonPath;
    }

    public JsonQuery.ArrayWrapperBehavior getWrapperBehavior() {
        return this.wrapperBehavior;
    }

    public Optional<JsonQuery.QuotesBehavior> getQuotesBehavior() {
        return this.quotesBehavior;
    }

    public JsonQuery.EmptyOrErrorBehavior getEmptyBehavior() {
        return this.emptyBehavior;
    }

    public Optional<JsonQuery.EmptyOrErrorBehavior> getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQueryColumn(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return (List)this.jsonPath.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("format", (Object)this.format).add("jsonPath", this.jsonPath.orElse(null)).add("wrapperBehavior", (Object)this.wrapperBehavior).add("quotesBehavior", this.quotesBehavior.orElse(null)).add("emptyBehavior", (Object)this.emptyBehavior).add("errorBehavior", this.errorBehavior.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryColumn that = (QueryColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals((Object)this.format, (Object)that.format) && Objects.equals(this.jsonPath, that.jsonPath) && this.wrapperBehavior == that.wrapperBehavior && Objects.equals(this.quotesBehavior, that.quotesBehavior) && this.emptyBehavior == that.emptyBehavior && Objects.equals(this.errorBehavior, that.errorBehavior);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.format, this.jsonPath, this.wrapperBehavior, this.quotesBehavior, this.emptyBehavior, this.errorBehavior});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!QueryColumn.sameClass(this, other)) {
            return false;
        }
        QueryColumn otherQueryColumn = (QueryColumn)other;
        return this.name.equals(otherQueryColumn.name) && this.type.equals(otherQueryColumn.type) && this.format.equals((Object)otherQueryColumn.format) && this.wrapperBehavior == otherQueryColumn.wrapperBehavior && Objects.equals(this.quotesBehavior, otherQueryColumn.quotesBehavior) && this.emptyBehavior == otherQueryColumn.emptyBehavior && Objects.equals(this.errorBehavior, otherQueryColumn.errorBehavior);
    }
}

