/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.HttpClientCallback;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientImpl;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientUtils;
import java.io.Closeable;
import java.net.SocketAddress;
import java.net.URI;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public abstract class HttpClient
implements Closeable {
    private final XnioWorker worker;

    protected HttpClient(XnioWorker worker) {
        this.worker = worker;
    }

    public XnioWorker getWorker() {
        return this.worker;
    }

    public abstract IoFuture<HttpClientConnection> connect(SocketAddress var1, OptionMap var2);

    public void connect(SocketAddress destination, OptionMap optionMap, HttpClientCallback<HttpClientConnection> completionHandler) {
        IoFuture<HttpClientConnection> connectionIoFuture = this.connect(destination, optionMap);
        HttpClientUtils.addCallback(connectionIoFuture, completionHandler);
    }

    public abstract IoFuture<HttpClientRequest> sendRequest(String var1, URI var2, OptionMap var3);

    public static HttpClient create(XnioWorker worker, OptionMap options) {
        return new HttpClientImpl(worker, options);
    }
}

