/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.api.WebSocketSessionIdGenerator;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.impl.UuidWebSocketSessionIdGenerator;
import io.undertow.websockets.impl.WebSocketChannelSession;
import io.undertow.websockets.impl.WebSocketRecieveListeners;
import io.undertow.websockets.spi.WebSocketHttpExchange;

public class WebSocketSessionConnectionCallback
implements WebSocketConnectionCallback {
    private final WebSocketSessionIdGenerator idGenerator;
    private final WebSocketSessionHandler sessionHandler;
    private final boolean executeInIoThread;

    public WebSocketSessionConnectionCallback(WebSocketSessionHandler sessionHandler) {
        this(new UuidWebSocketSessionIdGenerator(), sessionHandler, false);
    }

    public WebSocketSessionConnectionCallback(WebSocketSessionIdGenerator idGenerator, WebSocketSessionHandler sessionHandler) {
        this(idGenerator, sessionHandler, false);
    }

    public WebSocketSessionConnectionCallback(WebSocketSessionIdGenerator idGenerator, WebSocketSessionHandler sessionHandler, boolean executeInIoThread) {
        this.idGenerator = idGenerator;
        this.sessionHandler = sessionHandler;
        this.executeInIoThread = executeInIoThread;
    }

    @Override
    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        WebSocketChannelSession session = new WebSocketChannelSession(channel, this.idGenerator.nextId(), this.executeInIoThread);
        this.sessionHandler.onSession(session, exchange);
        WebSocketRecieveListeners.startRecieving(session, channel, this.executeInIoThread);
    }
}

