/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;

public class CachedAuthenticatedSessionMechanism
implements AuthenticationMechanism {
    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        AuthenticatedSessionManager sessionManager = exchange.getAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY);
        if (sessionManager != null) {
            return this.runCached(exchange, securityContext, sessionManager);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome runCached(HttpServerExchange exchange, SecurityContext securityContext, AuthenticatedSessionManager sessionManager) {
        AuthenticatedSessionManager.AuthenticatedSession authSession = sessionManager.lookupSession(exchange);
        if (authSession != null) {
            Account account = securityContext.getIdentityManager().verify(authSession.getAccount());
            if (account != null) {
                securityContext.authenticationComplete(account, authSession.getMechanism());
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }
}

