/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.websockets.core.function.ChannelFunction;
import java.nio.ByteBuffer;

final class Masker
implements ChannelFunction {
    private final byte[] maskingKey;
    int m;

    public Masker(int maskingKey) {
        this.maskingKey = Masker.createsMaskingKey(maskingKey);
    }

    private static byte[] createsMaskingKey(int maskingKey) {
        byte[] key = new byte[]{(byte)(maskingKey >> 24 & 0xFF), (byte)(maskingKey >> 16 & 0xFF), (byte)(maskingKey >> 8 & 0xFF), (byte)(maskingKey & 0xFF)};
        return key;
    }

    private void mask(ByteBuffer buf, int position, int length) {
        int limit = position + length;
        for (int i = position; i < limit; ++i) {
            buf.put(i, (byte)(buf.get(i) ^ this.maskingKey[this.m++]));
            this.m %= 4;
        }
    }

    @Override
    public void afterRead(ByteBuffer buf, int position, int length) {
        this.mask(buf, position, length);
    }

    @Override
    public void beforeWrite(ByteBuffer buf, int position, int length) {
        this.mask(buf, position, length);
    }

    @Override
    public void complete() {
    }
}

