/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.io.AsyncSenderImpl;
import io.undertow.io.BlockingSenderImpl;
import io.undertow.io.Sender;
import io.undertow.io.UndertowInputStream;
import io.undertow.io.UndertowOutputStream;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerConnection;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.NetworkUtils;
import io.undertow.util.Protocols;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.WrapperConduitFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.EmptyStreamSourceChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class HttpServerExchange
extends AbstractAttachable {
    public static final AttachmentKey<Executor> DISPATCH_EXECUTOR = AttachmentKey.create(Executor.class);
    public static final AttachmentKey<Runnable> DISPATCH_TASK = AttachmentKey.create(Runnable.class);
    private static final Logger log = Logger.getLogger(HttpServerExchange.class);
    private final HttpServerConnection connection;
    private final HeaderMap requestHeaders = new HeaderMap();
    private final HeaderMap responseHeaders = new HeaderMap();
    private int exchangeCompletionListenersCount = 0;
    private ExchangeCompletionListener[] exchangeCompleteListeners = new ExchangeCompletionListener[2];
    private final Deque<DefaultResponseListener> defaultResponseListeners = new ArrayDeque<DefaultResponseListener>(1);
    private Map<String, Deque<String>> queryParameters;
    private Map<String, Deque<String>> pathParameters;
    private WriteDispatchChannel responseChannel;
    private ReadDispatchChannel requestChannel;
    private BlockingHttpExchange blockingHttpExchange;
    private HttpString protocol;
    private int state = 200;
    private HttpString requestMethod;
    private String requestScheme;
    private String requestURI;
    private String requestPath;
    private String relativePath;
    private String resolvedPath = "";
    private String queryString = "";
    private int requestWrapperCount = 0;
    private ConduitWrapper<StreamSourceConduit>[] requestWrappers;
    private int responseWrapperCount = 0;
    private ConduitWrapper<StreamSinkConduit>[] responseWrappers = new ConduitWrapper[4];
    private Sender sender;
    private static final int MASK_RESPONSE_CODE = Bits.intBitMask((int)0, (int)9);
    private static final int FLAG_RESPONSE_SENT = 1024;
    private static final int FLAG_RESPONSE_TERMINATED = 2048;
    private static final int FLAG_REQUEST_TERMINATED = 4096;
    private static final int FLAG_PERSISTENT = 16384;
    private static final int FLAG_DISPATCHED = 32768;
    private static final int FLAG_URI_CONTAINS_HOST = 65536;
    private static final int FLAG_IN_CALL = 131072;

    public HttpServerExchange(HttpServerConnection connection) {
        this.connection = connection;
    }

    public HttpString getProtocol() {
        return this.protocol;
    }

    public void setProtocol(HttpString protocol) {
        this.protocol = protocol;
    }

    public boolean isHttp09() {
        return this.protocol.equals(Protocols.HTTP_0_9);
    }

    public boolean isHttp10() {
        return this.protocol.equals(Protocols.HTTP_1_0);
    }

    public boolean isHttp11() {
        return this.protocol.equals(Protocols.HTTP_1_1);
    }

    public HttpString getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(HttpString requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getRequestScheme() {
        return this.requestScheme;
    }

    public void setRequestScheme(String requestScheme) {
        this.requestScheme = requestScheme;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public boolean isHostIncludedInRequestURI() {
        return Bits.anyAreSet((int)this.state, (int)65536);
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    void setParsedRequestPath(boolean requestUriContainsHost, String requestUri, String requestPath) {
        this.requestURI = requestUri;
        this.relativePath = requestPath;
        this.requestPath = requestPath;
        if (requestUriContainsHost) {
            this.state |= 0x10000;
        }
    }

    void setParsedRequestPath(String requestPath) {
        this.relativePath = requestPath;
        this.requestPath = requestPath;
    }

    void setParsedRequestPath(boolean requestUriContainsHost, String requestUri) {
        this.requestURI = requestUri;
        if (requestUriContainsHost) {
            this.state |= 0x10000;
        }
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public void setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestURL() {
        if (this.isHostIncludedInRequestURI()) {
            return this.getRequestURI();
        }
        return this.getRequestScheme() + "://" + this.getHostAndPort() + this.getRequestURI();
    }

    public String getHostName() {
        String host = this.requestHeaders.getFirst(Headers.HOST);
        if (host == null) {
            host = this.getDestinationAddress().getAddress().getHostAddress();
        } else if (host.startsWith("[")) {
            host = host.substring(1, host.indexOf(93));
        } else if (host.indexOf(58) != -1) {
            host = host.substring(0, host.indexOf(58));
        }
        return host;
    }

    public String getHostAndPort() {
        String host = this.requestHeaders.getFirst(Headers.HOST);
        if (host == null) {
            host = NetworkUtils.formatPossibleIpv6Address(this.getDestinationAddress().getAddress().getHostAddress());
            int port = this.getDestinationAddress().getPort();
            if (!(this.getRequestScheme().equals("http") && port == 80 || this.getRequestScheme().equals("https") && port == 8080)) {
                host = host + ":" + port;
            }
        }
        return host;
    }

    public HttpServerConnection getConnection() {
        return this.connection;
    }

    public boolean isPersistent() {
        return Bits.anyAreSet((int)this.state, (int)16384);
    }

    public boolean isInIoThread() {
        return this.getIoThread() == Thread.currentThread();
    }

    public boolean isUpgrade() {
        return this.getResponseCode() == 101;
    }

    public void setPersistent(boolean persistent) {
        this.state = persistent ? (this.state |= 0x4000) : (this.state &= 0xFFFFBFFF);
    }

    public boolean isDispatched() {
        return Bits.anyAreSet((int)this.state, (int)32768);
    }

    public void unDispatch() {
        this.state &= 0xFFFF7FFF;
        this.removeAttachment(DISPATCH_EXECUTOR);
        this.removeAttachment(DISPATCH_TASK);
    }

    public void dispatch() {
        this.state |= 0x8000;
    }

    public void dispatch(Runnable runnable) {
        this.dispatch(null, runnable);
    }

    public void dispatch(Executor executor, Runnable runnable) {
        if (this.isInCall()) {
            this.state |= 0x8000;
            if (executor != null) {
                this.putAttachment(DISPATCH_EXECUTOR, executor);
            }
            this.putAttachment(DISPATCH_TASK, runnable);
        } else if (executor == null) {
            this.getConnection().getWorker().execute(runnable);
        } else {
            executor.execute(runnable);
        }
    }

    public void dispatch(HttpHandler handler) {
        this.dispatch(null, handler);
    }

    public void dispatch(Executor executor, final HttpHandler handler) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HttpHandlers.executeRootHandler(handler, HttpServerExchange.this, false);
            }
        };
        this.dispatch(executor, runnable);
    }

    public void setDispatchExecutor(Executor executor) {
        if (executor == null) {
            this.removeAttachment(DISPATCH_EXECUTOR);
        } else {
            this.putAttachment(DISPATCH_EXECUTOR, executor);
        }
    }

    public Executor getDispatchExecutor() {
        return this.getAttachment(DISPATCH_EXECUTOR);
    }

    boolean isInCall() {
        return Bits.anyAreSet((int)this.state, (int)131072);
    }

    void setInCall(boolean value) {
        this.state = value ? (this.state |= 0x20000) : (this.state &= 0xFFFDFFFF);
    }

    public void upgradeChannel(ExchangeCompletionListener upgradeCompleteListener) {
        this.setResponseCode(101);
        int exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners.length == exchangeCompletionListenersCount) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            System.arraycopy(old, 0, exchangeCompleteListeners, 1, exchangeCompletionListenersCount);
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        } else {
            for (int i = exchangeCompletionListenersCount - 1; i >= 0; --i) {
                exchangeCompleteListeners[i + 1] = exchangeCompleteListeners[i];
            }
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        }
    }

    public void upgradeChannel(String productName, ExchangeCompletionListener upgradeCompleteListener) {
        this.setResponseCode(101);
        HeaderMap headers = this.getResponseHeaders();
        headers.add(Headers.UPGRADE, productName);
        headers.add(Headers.CONNECTION, "Upgrade");
        int exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners.length == exchangeCompletionListenersCount) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            System.arraycopy(old, 0, exchangeCompleteListeners, 1, exchangeCompletionListenersCount);
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        } else {
            for (int i = exchangeCompletionListenersCount - 1; i >= 0; --i) {
                exchangeCompleteListeners[i + 1] = exchangeCompleteListeners[i];
            }
            exchangeCompleteListeners[0] = upgradeCompleteListener;
        }
    }

    public void addExchangeCompleteListener(ExchangeCompletionListener listener) {
        int exchangeCompletionListenersCount;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners.length == (exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++)) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            System.arraycopy(old, 0, exchangeCompleteListeners, 0, exchangeCompletionListenersCount);
        }
        exchangeCompleteListeners[exchangeCompletionListenersCount] = listener;
    }

    public void addDefaultResponseListener(DefaultResponseListener listener) {
        this.defaultResponseListeners.add(listener);
    }

    public InetSocketAddress getSourceAddress() {
        return this.connection.getPeerAddress(InetSocketAddress.class);
    }

    public InetSocketAddress getDestinationAddress() {
        return this.connection.getLocalAddress(InetSocketAddress.class);
    }

    public HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public long getRequestContentLength() {
        String contentLengthString = this.requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public HeaderMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public long getResponseContentLength() {
        String contentLengthString = this.responseHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public void setResponseContentLength(long length) {
        if (length == -1L) {
            this.responseHeaders.remove(Headers.CONTENT_LENGTH);
        } else {
            this.responseHeaders.put(Headers.CONTENT_LENGTH, Long.toString(length));
        }
    }

    public Map<String, Deque<String>> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        return this.queryParameters;
    }

    public void addQueryParam(String name, String param) {
        Deque<String> list;
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.queryParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.queryParameters.put(name, list);
        }
        list.add(param);
    }

    public Map<String, Deque<String>> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        return this.pathParameters;
    }

    public void addPathParam(String name, String param) {
        Deque<String> list;
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.pathParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.pathParameters.put(name, list);
        }
        list.add(param);
    }

    public boolean isResponseStarted() {
        return Bits.allAreSet((int)this.state, (int)1024);
    }

    public StreamSourceChannel getRequestChannel() {
        if (this.requestChannel != null) {
            return null;
        }
        if (Bits.anyAreSet((int)this.state, (int)4096)) {
            this.requestChannel = new ReadDispatchChannel((StreamSourceChannel)new EmptyStreamSourceChannel(this.getIoThread()));
            return this.requestChannel;
        }
        ConduitWrapper<StreamSourceConduit>[] wrappers = this.requestWrappers;
        ConduitStreamSourceChannel sourceChannel = this.connection.getChannel().getSourceChannel();
        if (wrappers != null) {
            this.requestWrappers = null;
            WrapperConduitFactory<StreamSourceConduit> factory = new WrapperConduitFactory<StreamSourceConduit>(wrappers, this.requestWrapperCount, sourceChannel.getConduit(), this);
            sourceChannel.setConduit(factory.create());
        }
        this.requestChannel = new ReadDispatchChannel((StreamSourceChannel)sourceChannel);
        return this.requestChannel;
    }

    public boolean isRequestChannelAvailable() {
        return this.requestChannel == null;
    }

    public boolean isComplete() {
        return Bits.allAreSet((int)this.state, (int)6144);
    }

    public void terminateRequest() {
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)4096)) {
            return;
        }
        if (this.requestChannel != null) {
            this.requestChannel.requestDone();
        }
        this.state = oldVal | 0x1000;
        if (Bits.anyAreSet((int)oldVal, (int)2048)) {
            this.invokeExchangeCompleteListeners();
        }
    }

    private void invokeExchangeCompleteListeners() {
        if (this.exchangeCompletionListenersCount > 0) {
            int i = this.exchangeCompletionListenersCount - 1;
            ExchangeCompletionListener next = this.exchangeCompleteListeners[i];
            next.exchangeEvent(this, new ExchangeCompleteNextListener(this.exchangeCompleteListeners, this, i));
        }
    }

    public void ungetRequestBytes(Pooled<ByteBuffer> unget) {
        if (this.connection.getExtraBytes() == null) {
            this.connection.setExtraBytes(unget);
        } else {
            Pooled<ByteBuffer> eb = this.connection.getExtraBytes();
            ByteBuffer buf = (ByteBuffer)eb.getResource();
            ByteBuffer ugBuffer = (ByteBuffer)unget.getResource();
            if (ugBuffer.limit() - ugBuffer.remaining() > buf.remaining()) {
                ugBuffer.compact();
                ugBuffer.put(buf);
                ugBuffer.flip();
                eb.free();
                this.connection.setExtraBytes(unget);
            } else {
                byte[] data = new byte[ugBuffer.remaining() + buf.remaining()];
                int first = ugBuffer.remaining();
                ugBuffer.get(data, 0, ugBuffer.remaining());
                buf.get(data, first, buf.remaining());
                eb.free();
                unget.free();
                final ByteBuffer newBuffer = ByteBuffer.wrap(data);
                this.connection.setExtraBytes(new Pooled<ByteBuffer>(){

                    public void discard() {
                    }

                    public void free() {
                    }

                    public ByteBuffer getResource() throws IllegalStateException {
                        return newBuffer;
                    }
                });
            }
        }
    }

    public StreamSinkChannel getResponseChannel() {
        ConduitWrapper<StreamSinkConduit>[] wrappers = this.responseWrappers;
        this.responseWrappers = null;
        if (wrappers == null) {
            return null;
        }
        ConduitStreamSinkChannel sinkChannel = this.connection.getChannel().getSinkChannel();
        WrapperConduitFactory<StreamSinkConduit> factory = new WrapperConduitFactory<StreamSinkConduit>(wrappers, this.responseWrapperCount, sinkChannel.getConduit(), this);
        sinkChannel.setConduit(factory.create());
        this.responseChannel = new WriteDispatchChannel((StreamSinkChannel)sinkChannel);
        this.startResponse();
        return this.responseChannel;
    }

    public Sender getResponseSender() {
        if (this.sender != null) {
            return this.sender;
        }
        if (this.blockingHttpExchange != null) {
            this.sender = this.blockingHttpExchange.getSender();
            return this.sender;
        }
        this.sender = new AsyncSenderImpl(this);
        return this.sender;
    }

    public boolean isResponseChannelAvailable() {
        return this.responseWrappers != null;
    }

    public void setResponseCode(int responseCode) {
        if (responseCode < 0 || responseCode > 999) {
            throw new IllegalArgumentException("Invalid response code");
        }
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal & ~MASK_RESPONSE_CODE | responseCode & MASK_RESPONSE_CODE;
    }

    public void addRequestWrapper(ConduitWrapper<StreamSourceConduit> wrapper) {
        ConduitWrapper<StreamSourceConduit>[] wrappers = this.requestWrappers;
        if (this.requestChannel != null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        if (wrappers == null) {
            wrappers = this.requestWrappers = new ConduitWrapper[2];
        } else if (wrappers.length == this.requestWrapperCount) {
            this.requestWrappers = new ConduitWrapper[wrappers.length + 2];
            System.arraycopy(wrappers, 0, this.requestWrappers, 0, wrappers.length);
            wrappers = this.requestWrappers;
        }
        wrappers[this.requestWrapperCount++] = wrapper;
    }

    public void addResponseWrapper(ConduitWrapper<StreamSinkConduit> wrapper) {
        ConduitWrapper<StreamSinkConduit>[] wrappers = this.responseWrappers;
        if (wrappers == null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        if (wrappers.length == this.responseWrapperCount) {
            this.responseWrappers = new ConduitWrapper[wrappers.length + 2];
            System.arraycopy(wrappers, 0, this.responseWrappers, 0, wrappers.length);
            wrappers = this.responseWrappers;
        }
        wrappers[this.responseWrapperCount++] = wrapper;
    }

    public BlockingHttpExchange startBlocking() {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = new DefaultBlockingHttpExchange(this);
        return old;
    }

    public BlockingHttpExchange startBlocking(BlockingHttpExchange httpExchange) {
        BlockingHttpExchange old = this.blockingHttpExchange;
        this.blockingHttpExchange = httpExchange;
        return old;
    }

    public InputStream getInputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this.blockingHttpExchange == null) {
            throw UndertowMessages.MESSAGES.startBlockingHasNotBeenCalled();
        }
        return this.blockingHttpExchange.getOutputStream();
    }

    public int getResponseCode() {
        return this.state & MASK_RESPONSE_CODE;
    }

    public void terminateResponse() {
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)2048)) {
            return;
        }
        this.responseChannel.responseDone();
        this.state = oldVal | 0x800;
        if (Bits.anyAreSet((int)oldVal, (int)4096)) {
            this.invokeExchangeCompleteListeners();
        }
    }

    public void endExchange() {
        final int state = this.state;
        if (Bits.allAreSet((int)state, (int)6144)) {
            return;
        }
        while (!this.defaultResponseListeners.isEmpty()) {
            DefaultResponseListener listener = this.defaultResponseListeners.poll();
            try {
                if (!listener.handleDefaultResponse(this)) continue;
                return;
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception running default response listener", e);
            }
        }
        if (this.blockingHttpExchange != null) {
            try {
                this.blockingHttpExchange.close();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.connection.getChannel());
            }
        }
        if (Bits.anyAreClear((int)state, (int)4096)) {
            if (this.requestChannel == null) {
                this.getRequestChannel();
            }
            int totalRead = 0;
            try {
                long read;
                do {
                    read = Channels.drain((StreamSourceChannel)this.requestChannel, (long)Long.MAX_VALUE);
                    totalRead = (int)((long)totalRead + read);
                    if (read != 0L) continue;
                    if (this.getResponseCode() != 417 || totalRead > 0) {
                        this.requestChannel.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<StreamSourceChannel>(){

                            public void handleEvent(StreamSourceChannel channel) {
                                if (Bits.anyAreClear((int)state, (int)2048)) {
                                    HttpServerExchange.this.closeAndFlushResponse();
                                }
                            }
                        }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSourceChannel>(){

                            public void handleException(StreamSourceChannel channel, IOException e) {
                                UndertowLogger.REQUEST_LOGGER.debug("Exception draining request stream", e);
                                IoUtils.safeClose((Closeable)HttpServerExchange.this.connection.getChannel());
                            }
                        }));
                        this.requestChannel.resumeReads();
                        return;
                    }
                    break;
                } while (read != -1L);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.connection.getChannel());
            }
        }
        if (Bits.anyAreClear((int)state, (int)2048)) {
            this.closeAndFlushResponse();
        }
    }

    private void closeAndFlushResponse() {
        try {
            if (this.isResponseChannelAvailable()) {
                this.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                this.getResponseChannel();
            }
            this.responseChannel.shutdownWrites();
            if (!this.responseChannel.flush()) {
                this.responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        channel.getWriteSetter().set(null);
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<Channel>(){

                    public void handleException(Channel channel, IOException exception) {
                        UndertowLogger.REQUEST_LOGGER.debug("Exception ending request", exception);
                        IoUtils.safeClose((Closeable)HttpServerExchange.this.connection.getChannel());
                    }
                }));
                this.responseChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
        }
    }

    void startResponse() throws IllegalStateException {
        int oldVal = this.state;
        if (Bits.allAreSet((int)oldVal, (int)1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        this.state = oldVal | 0x400;
        log.tracef("Starting to write response for %s", (Object)this);
    }

    public XnioIoThread getIoThread() {
        return this.connection.getIoThread();
    }

    private final class ReadDispatchChannel
    implements StreamSourceChannel,
    Runnable {
        private final StreamSourceChannel delegate;
        protected final ChannelListener.SimpleSetter<ReadDispatchChannel> readSetter = new ChannelListener.SimpleSetter();
        protected final ChannelListener.SimpleSetter<ReadDispatchChannel> closeSetter = new ChannelListener.SimpleSetter();

        public ReadDispatchChannel(StreamSourceChannel delegate) {
            this.delegate = delegate;
            delegate.getReadSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.readSetter));
            delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
        }

        public void resumeReads() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                HttpServerExchange.this.dispatch(SameThreadExecutor.INSTANCE, this);
            } else {
                this.delegate.resumeReads();
            }
        }

        @Override
        public void run() {
            if (!Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                this.delegate.resumeReads();
            }
        }

        public long transferTo(long position, long count, FileChannel target) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return -1L;
            }
            return this.delegate.transferTo(position, count, target);
        }

        public void awaitReadable() throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return;
            }
            this.delegate.awaitReadable();
        }

        public void suspendReads() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return;
            }
            this.delegate.suspendReads();
        }

        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return -1L;
            }
            return this.delegate.transferTo(count, throughBuffer, target);
        }

        public XnioWorker getWorker() {
            return this.delegate.getWorker();
        }

        public boolean isReadResumed() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return false;
            }
            return this.delegate.isReadResumed();
        }

        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return (T)this.delegate.setOption(option, value);
        }

        public boolean supportsOption(Option<?> option) {
            return this.delegate.supportsOption(option);
        }

        public void shutdownReads() throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return;
            }
            this.delegate.shutdownReads();
        }

        public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
            return this.readSetter;
        }

        public boolean isOpen() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return false;
            }
            return this.delegate.isOpen();
        }

        public long read(ByteBuffer[] dsts) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return -1L;
            }
            return this.delegate.read(dsts);
        }

        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return -1L;
            }
            return this.delegate.read(dsts, offset, length);
        }

        public void wakeupReads() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return;
            }
            this.delegate.wakeupReads();
        }

        public XnioExecutor getReadThread() {
            return this.delegate.getReadThread();
        }

        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            this.delegate.awaitReadable(time, timeUnit);
        }

        public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
            return this.closeSetter;
        }

        public void close() throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return;
            }
            this.delegate.close();
        }

        public <T> T getOption(Option<T> option) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                throw UndertowMessages.MESSAGES.streamIsClosed();
            }
            return (T)this.delegate.getOption(option);
        }

        public int read(ByteBuffer dst) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)4096)) {
                return -1;
            }
            return this.delegate.read(dst);
        }

        public XnioIoThread getIoThread() {
            return this.delegate.getIoThread();
        }

        public void requestDone() {
            this.delegate.getReadSetter().set(null);
            this.delegate.getCloseSetter().set(null);
            if (this.delegate.isReadResumed()) {
                this.delegate.suspendReads();
            }
        }
    }

    private class WriteDispatchChannel
    implements StreamSinkChannel,
    Runnable {
        protected final StreamSinkChannel delegate;
        protected final ChannelListener.SimpleSetter<WriteDispatchChannel> writeSetter = new ChannelListener.SimpleSetter();
        protected final ChannelListener.SimpleSetter<WriteDispatchChannel> closeSetter = new ChannelListener.SimpleSetter();
        private boolean wakeup;

        public WriteDispatchChannel(StreamSinkChannel delegate) {
            this.delegate = delegate;
            delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.writeSetter));
            delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
        }

        public void suspendWrites() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                return;
            }
            this.delegate.suspendWrites();
        }

        public boolean isWriteResumed() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                return false;
            }
            return this.delegate.isWriteResumed();
        }

        public void shutdownWrites() throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                return;
            }
            this.delegate.shutdownWrites();
        }

        public void awaitWritable() throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            this.delegate.awaitWritable();
        }

        public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            this.delegate.awaitWritable(time, timeUnit);
        }

        public XnioExecutor getWriteThread() {
            return this.delegate.getWriteThread();
        }

        public boolean isOpen() {
            return !Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048) && this.delegate.isOpen();
        }

        public void close() throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                return;
            }
            this.delegate.close();
        }

        public boolean flush() throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                return true;
            }
            return this.delegate.flush();
        }

        public long transferFrom(FileChannel src, long position, long count) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return this.delegate.transferFrom(src, position, count);
        }

        public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return this.delegate.transferFrom(source, count, throughBuffer);
        }

        public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
            return this.writeSetter;
        }

        public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
            return this.closeSetter;
        }

        public XnioWorker getWorker() {
            return this.delegate.getWorker();
        }

        public XnioIoThread getIoThread() {
            return this.delegate.getIoThread();
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return this.delegate.write(srcs, offset, length);
        }

        public long write(ByteBuffer[] srcs) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return this.delegate.write(srcs);
        }

        public boolean supportsOption(Option<?> option) {
            return this.delegate.supportsOption(option);
        }

        public <T> T getOption(Option<T> option) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return (T)this.delegate.getOption(option);
        }

        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return (T)this.delegate.setOption(option, value);
        }

        public int write(ByteBuffer src) throws IOException {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                throw UndertowMessages.MESSAGES.channelIsClosed();
            }
            return this.delegate.write(src);
        }

        public void resumeWrites() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = false;
                HttpServerExchange.this.dispatch(SameThreadExecutor.INSTANCE, this);
            } else {
                this.delegate.resumeWrites();
            }
        }

        public void wakeupWrites() {
            if (Bits.allAreSet((int)HttpServerExchange.this.state, (int)2048)) {
                return;
            }
            if (HttpServerExchange.this.isInCall()) {
                this.wakeup = true;
                HttpServerExchange.this.dispatch(SameThreadExecutor.INSTANCE, this);
            } else {
                this.delegate.wakeupWrites();
            }
        }

        @Override
        public void run() {
            if (this.wakeup) {
                this.delegate.wakeupWrites();
            } else {
                this.delegate.resumeWrites();
            }
        }

        public void responseDone() {
            this.delegate.getCloseSetter().set(null);
            this.delegate.getWriteSetter().set(null);
            if (this.delegate.isWriteResumed()) {
                this.delegate.suspendWrites();
            }
        }
    }

    private static class DefaultBlockingHttpExchange
    implements BlockingHttpExchange {
        private InputStream inputStream;
        private OutputStream outputStream;
        private Sender sender;
        private final HttpServerExchange exchange;

        DefaultBlockingHttpExchange(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = new UndertowInputStream(this.exchange);
            }
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = new UndertowOutputStream(this.exchange);
            }
            return this.outputStream;
        }

        @Override
        public Sender getSender() {
            if (this.sender == null) {
                this.sender = new BlockingSenderImpl(this.exchange, this.getOutputStream());
            }
            return this.sender;
        }

        @Override
        public void close() throws IOException {
            this.getInputStream().close();
            this.getOutputStream().close();
        }
    }

    private static class ExchangeCompleteNextListener
    implements ExchangeCompletionListener.NextListener {
        private final ExchangeCompletionListener[] list;
        private final HttpServerExchange exchange;
        private int i;

        public ExchangeCompleteNextListener(ExchangeCompletionListener[] list, HttpServerExchange exchange, int i) {
            this.list = list;
            this.exchange = exchange;
            this.i = i;
        }

        @Override
        public void proceed() {
            if (--this.i >= 0) {
                ExchangeCompletionListener next = this.list[this.i];
                next.exchangeEvent(this.exchange, this);
            }
        }
    }
}

