/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.Version;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.session.PathParameterSessionConfig;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SslSessionConfig;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.SessionConfigWrapper;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.spec.FilterRegistrationImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletRegistrationImpl;
import io.undertow.servlet.spec.SessionCookieConfigImpl;
import io.undertow.servlet.util.EmptyEnumeration;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.util.IteratorEnumeration;
import io.undertow.util.AttachmentKey;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.descriptor.JspConfigDescriptor;

public class ServletContextImpl
implements ServletContext {
    private final ServletContainer servletContainer;
    private final Deployment deployment;
    private DeploymentInfo deploymentInfo;
    private final ConcurrentMap<String, Object> attributes;
    private final SessionCookieConfigImpl sessionCookieConfig;
    private final AttachmentKey<HttpSessionImpl> sessionAttachmentKey = AttachmentKey.create(HttpSessionImpl.class);
    private volatile Set<SessionTrackingMode> sessionTrackingModes = new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL));
    private volatile Set<SessionTrackingMode> defaultSessionTrackingModes = new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL));
    private volatile SessionConfig sessionConfig;
    private volatile boolean initialized = false;

    public ServletContextImpl(ServletContainer servletContainer, Deployment deployment) {
        this.servletContainer = servletContainer;
        this.deployment = deployment;
        this.deploymentInfo = deployment.getDeploymentInfo();
        this.sessionCookieConfig = new SessionCookieConfigImpl(this);
        this.sessionCookieConfig.setPath(this.deploymentInfo.getContextPath());
        this.attributes = this.deploymentInfo.getServletContextAttributeBackingMap() == null ? new ConcurrentHashMap<String, Object>() : this.deploymentInfo.getServletContextAttributeBackingMap();
        this.attributes.putAll(deployment.getDeploymentInfo().getServletContextAttributes());
    }

    public void initDone() {
        SessionConfigWrapper wrapper;
        this.initialized = true;
        Set<SessionTrackingMode> trackingMethods = this.sessionTrackingModes;
        SessionCookieConfigImpl sessionConfig = this.sessionCookieConfig;
        if (trackingMethods != null && !trackingMethods.isEmpty()) {
            if (this.sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
                sessionConfig = new SslSessionConfig();
            } else if (this.sessionTrackingModes.contains(SessionTrackingMode.COOKIE) && this.sessionTrackingModes.contains(SessionTrackingMode.URL)) {
                this.sessionCookieConfig.setFallback((SessionConfig)new PathParameterSessionConfig(this.sessionCookieConfig.getName().toLowerCase(Locale.ENGLISH)));
            } else if (this.sessionTrackingModes.contains(SessionTrackingMode.URL)) {
                sessionConfig = new PathParameterSessionConfig(this.sessionCookieConfig.getName().toLowerCase(Locale.ENGLISH));
            }
        }
        if ((wrapper = this.deploymentInfo.getSessionConfigWrapper()) != null) {
            sessionConfig = wrapper.wrap(sessionConfig, this.deployment);
        }
        this.sessionConfig = sessionConfig;
    }

    public String getContextPath() {
        return this.deploymentInfo.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        DeploymentManager deploymentByPath = this.servletContainer.getDeploymentByPath(uripath);
        if (deploymentByPath == null) {
            return null;
        }
        return deploymentByPath.getDeployment().getServletContext();
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 1;
    }

    public int getEffectiveMajorVersion() {
        return this.deploymentInfo.getMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.deploymentInfo.getMinorVersion();
    }

    public String getMimeType(String file) {
        int pos = file.lastIndexOf(46);
        if (pos == -1) {
            return this.deployment.getMimeExtensionMappings().get(file);
        }
        return this.deployment.getMimeExtensionMappings().get(file.substring(pos + 1));
    }

    public Set<String> getResourcePaths(String path) {
        Resource resource;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null || !resource.isDirectory()) {
            return null;
        }
        HashSet<String> resources = new HashSet<String>();
        for (Resource res : resource.list()) {
            File file = res.getFile();
            if (file == null) continue;
            File base = res.getResourceManagerRoot();
            String filePath = file.getAbsolutePath().substring(base.getAbsolutePath().length());
            filePath = filePath.replace('\\', '/');
            if (file.isDirectory()) {
                filePath = filePath + "/";
            }
            resources.add(filePath);
        }
        return resources;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw UndertowServletMessages.MESSAGES.pathMustStartWithSlash(path);
        }
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        return resource.getUrl();
    }

    public InputStream getResourceAsStream(String path) {
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        try {
            if (resource.getFile() != null) {
                return new BufferedInputStream(new FileInputStream(resource.getFile()));
            }
            return new BufferedInputStream(resource.getUrl().openStream());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new RequestDispatcherImpl(path, this);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        ServletChain chain = this.deployment.getServletPaths().getServletHandlerByName(name);
        if (chain != null) {
            return new RequestDispatcherImpl(chain, this);
        }
        return null;
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.deployment.getServletPaths().getServletHandlerByName(name).getManagedServlet().getServlet().getInstance();
    }

    public Enumeration<Servlet> getServlets() {
        return EmptyEnumeration.instance();
    }

    public Enumeration<String> getServletNames() {
        return EmptyEnumeration.instance();
    }

    public void log(String msg) {
        UndertowServletLogger.ROOT_LOGGER.info(msg);
    }

    public void log(Exception exception, String msg) {
        UndertowServletLogger.ROOT_LOGGER.error(msg, exception);
    }

    public void log(String message, Throwable throwable) {
        UndertowServletLogger.ROOT_LOGGER.error(message, throwable);
    }

    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this.deploymentInfo.getResourceManager().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        File file = resource.getFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public String getServerInfo() {
        return this.deploymentInfo.getServerName() + " - " + Version.getVersionString();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.nullName();
        }
        return this.deploymentInfo.getInitParameters().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return new IteratorEnumeration<String>(this.deploymentInfo.getInitParameters().keySet().iterator());
    }

    public boolean setInitParameter(String name, String value) {
        if (this.deploymentInfo.getInitParameters().containsKey(name)) {
            return false;
        }
        this.deploymentInfo.addInitParameter(name, value);
        return true;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object object) {
        if (object == null) {
            Object existing = this.attributes.remove(name);
            if (this.deployment.getApplicationListeners() != null && existing != null) {
                this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, existing);
            }
        } else {
            Object existing = this.attributes.put(name, object);
            if (this.deployment.getApplicationListeners() != null) {
                if (existing != null) {
                    this.deployment.getApplicationListeners().servletContextAttributeReplaced(name, existing);
                } else {
                    this.deployment.getApplicationListeners().servletContextAttributeAdded(name, object);
                }
            }
        }
    }

    public void removeAttribute(String name) {
        Object exiting = this.attributes.remove(name);
        this.deployment.getApplicationListeners().servletContextAttributeRemoved(name, exiting);
    }

    public String getServletContextName() {
        return this.deploymentInfo.getDisplayName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        try {
            if (this.deploymentInfo.getServlets().containsKey(servletName)) {
                return null;
            }
            ServletInfo servlet = new ServletInfo(servletName, this.deploymentInfo.getClassLoader().loadClass(className));
            this.readServletAnnotations(servlet);
            this.deploymentInfo.addServlet(servlet);
            this.deployment.getServlets().addServlet(servlet);
            return new ServletRegistrationImpl(servlet, this.deployment);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getServlets().containsKey(servletName)) {
            return null;
        }
        ServletInfo s = new ServletInfo(servletName, servlet.getClass(), new ImmediateInstanceFactory<Servlet>(servlet));
        this.readServletAnnotations(s);
        this.deploymentInfo.addServlet(s);
        this.deployment.getServlets().addServlet(s);
        return new ServletRegistrationImpl(s, this.deployment);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getServlets().containsKey(servletName)) {
            return null;
        }
        ServletInfo servlet = new ServletInfo(servletName, servletClass);
        this.readServletAnnotations(servlet);
        this.deploymentInfo.addServlet(servlet);
        this.deployment.getServlets().addServlet(servlet);
        return new ServletRegistrationImpl(servlet, this.deployment);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        this.ensureNotProgramaticListener();
        try {
            return (T)((Servlet)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (Exception e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        this.ensureNotProgramaticListener();
        ServletInfo servlet = this.deploymentInfo.getServlets().get(servletName);
        if (servlet == null) {
            return null;
        }
        return new ServletRegistrationImpl(servlet, this.deployment);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        this.ensureNotProgramaticListener();
        HashMap<String, ServletRegistrationImpl> ret = new HashMap<String, ServletRegistrationImpl>();
        for (Map.Entry<String, ServletInfo> entry : this.deploymentInfo.getServlets().entrySet()) {
            ret.put(entry.getKey(), new ServletRegistrationImpl(entry.getValue(), this.deployment));
        }
        return ret;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getFilters().containsKey(filterName)) {
            return null;
        }
        try {
            FilterInfo filter = new FilterInfo(filterName, this.deploymentInfo.getClassLoader().loadClass(className));
            this.deploymentInfo.addFilter(filter);
            this.deployment.getFilters().addFilter(filter);
            return new FilterRegistrationImpl(filter, this.deployment);
        }
        catch (ClassNotFoundException e) {
            throw UndertowServletMessages.MESSAGES.cannotLoadClass(className, e);
        }
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getFilters().containsKey(filterName)) {
            return null;
        }
        FilterInfo f = new FilterInfo(filterName, filter.getClass(), new ImmediateInstanceFactory<Filter>(filter));
        this.deploymentInfo.addFilter(f);
        this.deployment.getFilters().addFilter(f);
        return new FilterRegistrationImpl(f, this.deployment);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (this.deploymentInfo.getFilters().containsKey(filterName)) {
            return null;
        }
        FilterInfo filter = new FilterInfo(filterName, filterClass);
        this.deploymentInfo.addFilter(filter);
        this.deployment.getFilters().addFilter(filter);
        return new FilterRegistrationImpl(filter, this.deployment);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        this.ensureNotProgramaticListener();
        try {
            return (T)((Filter)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (Exception e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        this.ensureNotProgramaticListener();
        FilterInfo filterInfo = this.deploymentInfo.getFilters().get(filterName);
        if (filterInfo == null) {
            return null;
        }
        return new FilterRegistrationImpl(filterInfo, this.deployment);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        this.ensureNotProgramaticListener();
        HashMap<String, FilterRegistrationImpl> ret = new HashMap<String, FilterRegistrationImpl>();
        for (Map.Entry<String, FilterInfo> entry : this.deploymentInfo.getFilters().entrySet()) {
            ret.put(entry.getKey(), new FilterRegistrationImpl(entry.getValue(), this.deployment));
        }
        return ret;
    }

    public SessionCookieConfigImpl getSessionCookieConfig() {
        this.ensureNotProgramaticListener();
        return this.sessionCookieConfig;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.ensureNotProgramaticListener();
        this.ensureNotInitialized();
        if (sessionTrackingModes.size() > 1 && sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            throw UndertowServletMessages.MESSAGES.sslCannotBeCombinedWithAnyOtherMethod();
        }
        this.sessionTrackingModes = new HashSet<SessionTrackingMode>(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        this.ensureNotProgramaticListener();
        return this.defaultSessionTrackingModes;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        this.ensureNotProgramaticListener();
        return Collections.unmodifiableSet(this.sessionTrackingModes);
    }

    public void addListener(String className) {
        try {
            Class<?> clazz = this.deploymentInfo.getClassLoader().loadClass(className);
            this.addListener(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        this.ensureNotInitialized();
        this.ensureNotProgramaticListener();
        if (ApplicationListeners.listenerState() != ApplicationListeners.ListenerState.NO_LISTENER && ServletContextListener.class.isAssignableFrom(t.getClass())) {
            throw UndertowServletMessages.MESSAGES.cannotAddServletContextListener();
        }
        ListenerInfo listener = new ListenerInfo(t.getClass(), new ImmediateInstanceFactory<T>(t));
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener, true));
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.ensureNotInitialized();
        this.ensureNotProgramaticListener();
        if (ApplicationListeners.listenerState() != ApplicationListeners.ListenerState.NO_LISTENER && ServletContextListener.class.isAssignableFrom(listenerClass)) {
            throw UndertowServletMessages.MESSAGES.cannotAddServletContextListener();
        }
        InstanceFactory<? extends EventListener> factory = null;
        try {
            factory = this.deploymentInfo.getClassIntrospecter().createInstanceFactory(listenerClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        ListenerInfo listener = new ListenerInfo(listenerClass, factory);
        this.deploymentInfo.addListener(listener);
        this.deployment.getApplicationListeners().addListener(new ManagedListener(listener, true));
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        this.ensureNotProgramaticListener();
        if (!ApplicationListeners.isListenerClass(clazz)) {
            throw UndertowServletMessages.MESSAGES.listenerMustImplementListenerClass(clazz);
        }
        try {
            return (T)((EventListener)this.deploymentInfo.getClassIntrospecter().createInstanceFactory(clazz).createInstance().getInstance());
        }
        catch (Exception e) {
            throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(clazz.getName(), e);
        }
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.deploymentInfo.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.deploymentInfo.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
    }

    public String getVirtualServerName() {
        return this.deployment.getDeploymentInfo().getHostName();
    }

    public HttpSessionImpl getSession(String sessionId) {
        SessionManager sessionManager = this.deployment.getSessionManager();
        Session session = sessionManager.getSession(sessionId);
        if (session != null) {
            return HttpSessionImpl.forSession(session, this, false);
        }
        return null;
    }

    public HttpSessionImpl getSession(SessionConfig c, HttpServerExchange exchange, boolean create) {
        HttpSessionImpl httpSession = (HttpSessionImpl)exchange.getAttachment(this.sessionAttachmentKey);
        if (httpSession != null && httpSession.isInvalid()) {
            exchange.removeAttachment(this.sessionAttachmentKey);
            httpSession = null;
        }
        if (httpSession == null) {
            SessionManager sessionManager = this.deployment.getSessionManager();
            Session session = sessionManager.getSession(exchange, c);
            if (session != null) {
                httpSession = HttpSessionImpl.forSession(session, this, false);
                exchange.putAttachment(this.sessionAttachmentKey, (Object)httpSession);
            } else if (create) {
                Session newSession = sessionManager.createSession(exchange, c);
                httpSession = HttpSessionImpl.forSession(newSession, this, true);
                exchange.putAttachment(this.sessionAttachmentKey, (Object)httpSession);
            }
        }
        return httpSession;
    }

    public HttpSessionImpl getSession(HttpServerExchange exchange, boolean create) {
        return this.getSession(this.sessionConfig, exchange, create);
    }

    public void updateSessionAccessTime(HttpServerExchange exchange) {
        HttpSessionImpl httpSession = this.getSession(exchange, false);
        if (httpSession != null) {
            Session underlyingSession = System.getSecurityManager() == null ? httpSession.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(httpSession));
            underlyingSession.requestDone(exchange);
        }
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    private void ensureNotInitialized() {
        if (this.initialized) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
    }

    private void ensureNotProgramaticListener() {
        if (ApplicationListeners.listenerState() == ApplicationListeners.ListenerState.PROGRAMATIC_LISTENER) {
            throw UndertowServletMessages.MESSAGES.cannotCallFromProgramaticListener();
        }
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void destroy() {
        this.attributes.clear();
        this.deploymentInfo = null;
    }

    private void readServletAnnotations(ServletInfo servlet) {
        if (System.getSecurityManager() == null) {
            new ReadServletAnnotationsTask(servlet, this.deploymentInfo).run();
        } else {
            AccessController.doPrivileged(new ReadServletAnnotationsTask(servlet, this.deploymentInfo));
        }
    }

    public void setDefaultSessionTrackingModes(HashSet<SessionTrackingMode> sessionTrackingModes) {
        this.defaultSessionTrackingModes = sessionTrackingModes;
        this.sessionTrackingModes = sessionTrackingModes;
    }

    private static final class ReadServletAnnotationsTask
    implements PrivilegedAction<Void> {
        private final ServletInfo servletInfo;
        private final DeploymentInfo deploymentInfo;

        private ReadServletAnnotationsTask(ServletInfo servletInfo, DeploymentInfo deploymentInfo) {
            this.servletInfo = servletInfo;
            this.deploymentInfo = deploymentInfo;
        }

        @Override
        public Void run() {
            DeclareRoles declareRoles;
            RunAs runAs;
            MultipartConfig multipartConfig;
            ServletSecurity security = this.servletInfo.getServletClass().getAnnotation(ServletSecurity.class);
            if (security != null) {
                ServletSecurityInfo servletSecurityInfo = (ServletSecurityInfo)((ServletSecurityInfo)((ServletSecurityInfo)new ServletSecurityInfo().setEmptyRoleSemantic(security.value().value() == ServletSecurity.EmptyRoleSemantic.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(security.value().transportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).addRolesAllowed(security.value().rolesAllowed());
                for (HttpMethodConstraint constraint : security.httpMethodConstraints()) {
                    ((ServletSecurityInfo)((ServletSecurityInfo)servletSecurityInfo.addHttpMethodSecurityInfo(new HttpMethodSecurityInfo().setMethod(constraint.value())).setEmptyRoleSemantic(constraint.emptyRoleSemantic() == ServletSecurity.EmptyRoleSemantic.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(constraint.transportGuarantee() == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE)).addRolesAllowed(constraint.rolesAllowed());
                }
                this.servletInfo.setServletSecurityInfo(servletSecurityInfo);
            }
            if ((multipartConfig = this.servletInfo.getServletClass().getAnnotation(MultipartConfig.class)) != null) {
                this.servletInfo.setMultipartConfig(new MultipartConfigElement(multipartConfig.location(), multipartConfig.maxFileSize(), multipartConfig.maxRequestSize(), multipartConfig.fileSizeThreshold()));
            }
            if ((runAs = this.servletInfo.getServletClass().getAnnotation(RunAs.class)) != null) {
                this.servletInfo.setRunAs(runAs.value());
            }
            if ((declareRoles = this.servletInfo.getServletClass().getAnnotation(DeclareRoles.class)) != null) {
                this.deploymentInfo.addSecurityRoles(declareRoles.value());
            }
            return null;
        }
    }
}

