/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.TypeModifier;
import io.vavr.jackson.datatype.VavrTypeModifier;
import io.vavr.jackson.datatype.deserialize.VavrDeserializers;
import io.vavr.jackson.datatype.serialize.VavrSerializers;

public class VavrModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private final Settings settings;

    public VavrModule() {
        this(new Settings());
    }

    public VavrModule(Settings settings) {
        this.settings = settings;
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addSerializers((Serializers)new VavrSerializers(this.settings));
        context.addDeserializers((Deserializers)new VavrDeserializers(this.settings));
        context.addTypeModifier((TypeModifier)new VavrTypeModifier());
    }

    public static class Settings {
        private boolean plainOption = true;
        private boolean deserializeNullAsEmptyCollection = false;

        public Settings useOptionInPlainFormat(boolean value) {
            this.plainOption = value;
            return this;
        }

        public Settings deserializeNullAsEmptyCollection(boolean value) {
            this.deserializeNullAsEmptyCollection = value;
            return this;
        }

        public boolean useOptionInPlainFormat() {
            return this.plainOption;
        }

        public boolean deserializeNullAsEmptyCollection() {
            return this.deserializeNullAsEmptyCollection;
        }
    }
}

