/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.vavr.control.Either;
import io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import java.io.IOException;

class EitherDeserializer
extends ValueDeserializer<Either<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private JsonDeserializer<?> stringDeserializer;

    EitherDeserializer(JavaType valueType) {
        super(valueType, 2);
        this.javaType = valueType;
    }

    public Either<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken nextToken = p.getCurrentToken();
        if (nextToken == JsonToken.START_ARRAY) {
            boolean right = false;
            Object value = null;
            int cnt = 0;
            JsonToken jsonToken = p.nextToken();
            while (jsonToken != JsonToken.END_ARRAY) {
                switch (++cnt) {
                    case 1: {
                        String def = (String)this.stringDeserializer.deserialize(p, ctxt);
                        if (EitherDeserializer.isRight(def)) {
                            right = true;
                            break;
                        }
                        if (EitherDeserializer.isLeft(def)) {
                            right = false;
                            break;
                        }
                        throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), jsonToken);
                    }
                    case 2: {
                        JsonDeserializer<?> deserializer = right ? this.deserializer(1) : this.deserializer(0);
                        value = jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
                    }
                }
                jsonToken = p.nextToken();
            }
            if (cnt != 2) {
                throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), null);
            }
            return right ? Either.right(value) : Either.left(value);
        }
        if (nextToken == JsonToken.START_OBJECT) {
            JsonToken currentToken = p.getCurrentToken();
            String type = p.nextFieldName();
            if (EitherDeserializer.isRight(type)) {
                JsonDeserializer<?> deserializer = this.deserializer(1);
                Object value = p.nextToken() != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
                return Either.right((Object)value);
            }
            if (EitherDeserializer.isLeft(type)) {
                JsonDeserializer<?> deserializer = this.deserializer(0);
                Object value = p.nextToken() != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
                return Either.left((Object)value);
            }
            throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), currentToken);
        }
        throw EitherDeserializer.mappingException(ctxt, this.javaType.getRawClass(), p.getCurrentToken());
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        this.stringDeserializer = ctxt.findContextualValueDeserializer(ctxt.constructType(String.class), null);
    }

    private static boolean isRight(String fieldName) {
        return "right".equals(fieldName) || "r".equals(fieldName);
    }

    private static boolean isLeft(String fieldName) {
        return "left".equals(fieldName) || "l".equals(fieldName);
    }
}

