/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.vavr.Lazy;
import io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import java.io.IOException;

class LazyDeserializer
extends ValueDeserializer<Lazy<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    private final JavaType fullType;
    private final JavaType valueType;
    private final TypeDeserializer valueTypeDeserializer;
    private final JsonDeserializer<?> valueDeserializer;

    LazyDeserializer(JavaType fullType, JavaType valueType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(valueType, 1);
        this.fullType = fullType;
        this.valueType = valueType;
        this.valueTypeDeserializer = typeDeser;
        this.valueDeserializer = valueDeser;
    }

    private LazyDeserializer(LazyDeserializer origin, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        this(origin.fullType, origin.valueType, typeDeser, valueDeser);
    }

    public Lazy<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object value = this.valueTypeDeserializer == null ? this.valueDeserializer.deserialize(p, ctxt) : this.valueDeserializer.deserializeWithType(p, ctxt, this.valueTypeDeserializer);
        return Lazy.of(() -> value);
    }

    public Lazy<?> getNullValue(DeserializationContext ctxt) {
        return Lazy.of(() -> null);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this.valueDeserializer;
        TypeDeserializer typeDeser = this.valueTypeDeserializer;
        JavaType refType = this.valueType;
        deser = deser == null ? ctxt.findContextualValueDeserializer(refType, property) : ctxt.handleSecondaryContextualization(deser, property, refType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return new LazyDeserializer(this, typeDeser, deser);
    }
}

