/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import java.io.Serializable;
import java.util.Comparator;

abstract class MaplikeDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    final MapLikeType mapType;
    final Comparator<Object> keyComparator;
    final KeyDeserializer keyDeserializer;
    final TypeDeserializer elementTypeDeserializer;
    final JsonDeserializer<?> elementDeserializer;

    MaplikeDeserializer(MapLikeType mapType, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        super((JavaType)mapType);
        this.mapType = mapType;
        this.keyComparator = this.createKeyComparator(mapType.getKeyType());
        this.keyDeserializer = keyDeserializer;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer;
    }

    private Comparator<Object> createKeyComparator(JavaType keyType) {
        if (Comparable.class.isAssignableFrom(keyType.getRawClass())) {
            Comparator comparator = (Comparator & Serializable)(o1, o2) -> ((Comparable)o1).compareTo(o2);
            return comparator;
        }
        return (Comparator & Serializable)(o1, o2) -> o1.toString().compareTo(o2.toString());
    }

    abstract MaplikeDeserializer<T> createDeserializer(KeyDeserializer var1, TypeDeserializer var2, JsonDeserializer<?> var3);

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
        JsonDeserializer elementDeser;
        KeyDeserializer keyDeser = this.keyDeserializer;
        if (keyDeser == null) {
            keyDeser = context.findKeyDeserializer(this.mapType.getKeyType(), property);
        } else if (keyDeser instanceof ContextualKeyDeserializer) {
            keyDeser = ((ContextualKeyDeserializer)keyDeser).createContextual(context, property);
        }
        TypeDeserializer elementTypeDeser = this.elementTypeDeserializer;
        if (elementTypeDeser != null) {
            elementTypeDeser = elementTypeDeser.forProperty(property);
        }
        elementDeser = (elementDeser = this.elementDeserializer) == null ? context.findContextualValueDeserializer(this.mapType.getContentType(), property) : context.handleSecondaryContextualization(elementDeser, property, this.mapType.getContentType());
        return this.createDeserializer(keyDeser, elementTypeDeser, elementDeser);
    }
}

