/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.vavr.collection.PriorityQueue;
import io.vavr.jackson.datatype.deserialize.ArrayDeserializer;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

class PriorityQueueDeserializer
extends ArrayDeserializer<PriorityQueue<?>> {
    private static final long serialVersionUID = 1L;

    PriorityQueueDeserializer(JavaType collectionType, JavaType elementType, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, boolean deserializeNullAsEmptyCollection) {
        super(collectionType, 1, elementType, elementTypeDeserializer, elementDeserializer, deserializeNullAsEmptyCollection);
    }

    PriorityQueueDeserializer(PriorityQueueDeserializer origin, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        this(origin.collectionType, origin.elementType, elementTypeDeserializer, elementDeserializer, origin.deserializeNullAsEmptyCollection);
    }

    @Override
    PriorityQueue<?> create(List<Object> list, DeserializationContext ctxt) throws JsonMappingException {
        PriorityQueueDeserializer.checkContainedTypeIsComparable(ctxt, this.collectionType.containedTypeOrUnknown(0));
        return PriorityQueue.ofAll((Comparator & Serializable)(o1, o2) -> ((Comparable)o1).compareTo(o2), list);
    }

    PriorityQueueDeserializer createDeserializer(TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        return new PriorityQueueDeserializer(this, elementTypeDeserializer, elementDeserializer);
    }
}

