/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Set;
import io.vavr.collection.SortedSet;
import io.vavr.collection.TreeSet;
import io.vavr.jackson.datatype.deserialize.ArrayDeserializer;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

class SetDeserializer
extends ArrayDeserializer<Set<?>> {
    private static final long serialVersionUID = 1L;

    SetDeserializer(JavaType collectionType, JavaType elementType, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, boolean deserializeNullAsEmptyCollection) {
        super(collectionType, 1, elementType, elementTypeDeserializer, elementDeserializer, deserializeNullAsEmptyCollection);
    }

    private SetDeserializer(SetDeserializer origin, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        this(origin.collectionType, origin.elementType, elementTypeDeserializer, elementDeserializer, origin.deserializeNullAsEmptyCollection);
    }

    @Override
    Set<?> create(List<Object> result, DeserializationContext ctx) throws JsonMappingException {
        if (SortedSet.class.isAssignableFrom(this.collectionType.getRawClass())) {
            SetDeserializer.checkContainedTypeIsComparable(ctx, this.collectionType.containedTypeOrUnknown(0));
            return TreeSet.ofAll((Comparator & Serializable)(o1, o2) -> ((Comparable)o1).compareTo(o2), result);
        }
        if (LinkedHashSet.class.isAssignableFrom(this.collectionType.getRawClass())) {
            return LinkedHashSet.ofAll(result);
        }
        return HashSet.ofAll(result);
    }

    SetDeserializer createDeserializer(TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        return new SetDeserializer(this, elementTypeDeserializer, elementDeserializer);
    }
}

