/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.vavr.collection.Multimap;
import io.vavr.jackson.datatype.serialize.ValueSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

class MultimapSerializer
extends ValueSerializer<Multimap<?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final MapLikeType mapType;

    MultimapSerializer(MapLikeType mapType) {
        this(mapType, null);
    }

    MultimapSerializer(MapLikeType mapType, BeanProperty beanProperty) {
        super((JavaType)mapType, beanProperty);
        this.mapType = mapType;
    }

    @Override
    Object toJavaObj(Multimap<?, ?> value) throws IOException {
        LinkedHashMap result = new LinkedHashMap();
        value.forEach(e -> {
            ArrayList<Object> list = (ArrayList<Object>)result.get(e._1);
            if (list == null) {
                list = new ArrayList<Object>();
                result.put(e._1, list);
            }
            list.add(e._2);
        });
        return result;
    }

    @Override
    JavaType emulatedJavaType(TypeFactory typeFactory) {
        CollectionType containerType = typeFactory.constructCollectionType(ArrayList.class, this.mapType.getContentType());
        return typeFactory.constructMapType(LinkedHashMap.class, this.mapType.getKeyType(), (JavaType)containerType);
    }

    public boolean isEmpty(SerializerProvider provider, Multimap<?, ?> value) {
        return value.isEmpty();
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (property == this.beanProperty) {
            return this;
        }
        return new MultimapSerializer(this.mapType, property);
    }
}

