/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.vavr.control.Option;
import io.vavr.jackson.datatype.serialize.HListSerializer;
import java.io.IOException;

class OptionSerializer
extends HListSerializer<Option<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final boolean plainMode;
    private final TypeSerializer valueTypeSerializer;
    private final JsonSerializer<Object> valueSerializer;
    private final JavaType fullType;
    private final JavaType valueType;

    OptionSerializer(JavaType fullType, JavaType valueType, TypeSerializer valueTypeSerializer, JsonSerializer<?> valueSerializer, boolean plainMode) {
        super(fullType);
        this.fullType = fullType;
        this.valueType = valueType;
        this.plainMode = plainMode;
        this.valueTypeSerializer = valueTypeSerializer;
        this.valueSerializer = valueSerializer;
    }

    public void serialize(Option<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.plainMode) {
            if (value.isDefined()) {
                if (this.valueSerializer != null) {
                    this.valueSerializer.serialize(value.get(), gen, provider);
                } else {
                    this.write(value.get(), 0, gen, provider);
                }
            } else {
                gen.writeNull();
            }
        } else {
            gen.writeStartArray();
            if (value.isDefined()) {
                gen.writeString("defined");
                this.write(value.get(), 0, gen, provider);
            } else {
                gen.writeString("undefined");
            }
            gen.writeEndArray();
        }
    }

    public boolean isEmpty(SerializerProvider provider, Option<?> value) {
        return value.isEmpty();
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser;
        TypeSerializer vts = this.valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(property);
        }
        if ((ser = this.valueSerializer) == null) {
            if (this.useStatic(provider, property, this.valueType)) {
                ser = provider.findTypedValueSerializer(this.valueType, true, property);
            }
        } else {
            ser = provider.handlePrimaryContextualization(ser, property);
        }
        return this.withResolved(this.fullType, vts, ser);
    }

    private boolean useStatic(SerializerProvider provider, BeanProperty property, JavaType referredType) {
        AnnotatedMember ann;
        if (referredType.isJavaLangObject()) {
            return false;
        }
        if (referredType.isFinal()) {
            return true;
        }
        if (referredType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (ann = property.getMember()) != null) {
            JsonSerialize.Typing t = intr.findSerializationTyping((Annotated)property.getMember());
            if (t == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (t == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return provider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    private OptionSerializer withResolved(JavaType refType, TypeSerializer typeSer, JsonSerializer<?> valueSer) {
        if (refType == this.valueType && typeSer == this.valueTypeSerializer && valueSer == this.valueSerializer) {
            return this;
        }
        return new OptionSerializer(refType, this.valueType, typeSer, valueSer, this.plainMode);
    }
}

