/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;

abstract class ValueSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 1L;
    final JavaType type;
    final BeanProperty beanProperty;

    ValueSerializer(JavaType type) {
        this(type, null);
    }

    ValueSerializer(JavaType type, BeanProperty property) {
        super(type);
        this.type = type;
        this.beanProperty = property;
    }

    abstract Object toJavaObj(T var1) throws IOException;

    abstract JavaType emulatedJavaType(TypeFactory var1);

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Object obj = this.toJavaObj(value);
        if (obj == null) {
            provider.getDefaultNullValueSerializer().serialize(null, gen, provider);
        } else {
            JsonSerializer ser;
            try {
                JavaType emulated = this.emulatedJavaType(provider.getTypeFactory());
                ser = emulated.getRawClass() != Object.class ? provider.findTypedValueSerializer(emulated, true, this.beanProperty) : provider.findTypedValueSerializer(obj.getClass(), true, this.beanProperty);
            }
            catch (Exception ignore) {
                ser = provider.findTypedValueSerializer(obj.getClass(), true, this.beanProperty);
            }
            ser.serialize(obj, gen, provider);
        }
    }

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForScalar(value, gen);
    }
}

