/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction3;
import io.vavr.CheckedFunction4;
import io.vavr.CheckedFunction5;
import io.vavr.CheckedFunction6;
import io.vavr.CheckedFunction7;
import io.vavr.CheckedFunction8;
import io.vavr.Function0;
import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.Function4;
import io.vavr.Function5;
import io.vavr.Function6;
import io.vavr.Function7;
import io.vavr.Function8;
import io.vavr.Lazy;
import io.vavr.Tuple0;
import io.vavr.Tuple1;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;
import io.vavr.Tuple5;
import io.vavr.Tuple6;
import io.vavr.Tuple7;
import io.vavr.Tuple8;
import io.vavr.collection.CharSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.PriorityQueue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.jackson.datatype.VavrModule;
import io.vavr.jackson.datatype.serialize.ArraySerializer;
import io.vavr.jackson.datatype.serialize.CharSeqSerializer;
import io.vavr.jackson.datatype.serialize.EitherSerializer;
import io.vavr.jackson.datatype.serialize.LazySerializer;
import io.vavr.jackson.datatype.serialize.MapSerializer;
import io.vavr.jackson.datatype.serialize.MultimapSerializer;
import io.vavr.jackson.datatype.serialize.OptionSerializer;
import io.vavr.jackson.datatype.serialize.SerializableSerializer;
import io.vavr.jackson.datatype.serialize.Tuple0Serializer;
import io.vavr.jackson.datatype.serialize.Tuple1Serializer;
import io.vavr.jackson.datatype.serialize.Tuple2Serializer;
import io.vavr.jackson.datatype.serialize.Tuple3Serializer;
import io.vavr.jackson.datatype.serialize.Tuple4Serializer;
import io.vavr.jackson.datatype.serialize.Tuple5Serializer;
import io.vavr.jackson.datatype.serialize.Tuple6Serializer;
import io.vavr.jackson.datatype.serialize.Tuple7Serializer;
import io.vavr.jackson.datatype.serialize.Tuple8Serializer;

public class VavrSerializers
extends Serializers.Base {
    private final VavrModule.Settings settings;

    public VavrSerializers(VavrModule.Settings settings) {
        this.settings = settings;
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class raw = type.getRawClass();
        if (Either.class.isAssignableFrom(raw)) {
            return new EitherSerializer(type);
        }
        if (Tuple0.class.isAssignableFrom(raw)) {
            return new Tuple0Serializer(type);
        }
        if (Tuple1.class.isAssignableFrom(raw)) {
            return new Tuple1Serializer(type);
        }
        if (Tuple2.class.isAssignableFrom(raw)) {
            return new Tuple2Serializer(type);
        }
        if (Tuple3.class.isAssignableFrom(raw)) {
            return new Tuple3Serializer(type);
        }
        if (Tuple4.class.isAssignableFrom(raw)) {
            return new Tuple4Serializer(type);
        }
        if (Tuple5.class.isAssignableFrom(raw)) {
            return new Tuple5Serializer(type);
        }
        if (Tuple6.class.isAssignableFrom(raw)) {
            return new Tuple6Serializer(type);
        }
        if (Tuple7.class.isAssignableFrom(raw)) {
            return new Tuple7Serializer(type);
        }
        if (Tuple8.class.isAssignableFrom(raw)) {
            return new Tuple8Serializer(type);
        }
        if (Function0.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function1.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function2.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function3.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function4.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function5.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function6.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function7.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (Function8.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction0.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction1.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction2.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction3.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction4.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction5.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction6.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction7.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        if (CheckedFunction8.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type);
        }
        return super.findSerializer(config, type, beanDesc);
    }

    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType type, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        Class raw = type.getRawClass();
        if (Lazy.class.isAssignableFrom(raw)) {
            return new LazySerializer((JavaType)type, type.getContentType(), contentTypeSerializer, contentValueSerializer);
        }
        if (Option.class.isAssignableFrom(raw)) {
            return new OptionSerializer((JavaType)type, type.getContentType(), contentTypeSerializer, contentValueSerializer, this.settings.useOptionInPlainFormat());
        }
        return super.findReferenceSerializer(config, type, beanDesc, contentTypeSerializer, contentValueSerializer);
    }

    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig config, CollectionLikeType collectionType, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class raw = collectionType.getRawClass();
        if (raw == CharSeq.class) {
            return new CharSeqSerializer((JavaType)collectionType);
        }
        if (Seq.class.isAssignableFrom(raw)) {
            return new ArraySerializer(collectionType);
        }
        if (Set.class.isAssignableFrom(raw)) {
            return new ArraySerializer(collectionType);
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return new ArraySerializer(collectionType);
        }
        return super.findCollectionLikeSerializer(config, collectionType, beanDesc, elementTypeSerializer, elementValueSerializer);
    }

    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class raw = type.getRawClass();
        if (Map.class.isAssignableFrom(raw)) {
            return new MapSerializer(type);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new MultimapSerializer(type);
        }
        return super.findMapLikeSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
    }
}

