/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htpasswd.impl.hash;

import io.vertx.ext.auth.HashString;
import io.vertx.ext.auth.HashingAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class SHA1
implements HashingAlgorithm {
    private static final Base64.Encoder B64ENC = Base64.getEncoder();
    private final MessageDigest md;

    public SHA1() {
        try {
            this.md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SHA1 is not available", nsae);
        }
    }

    public String id() {
        return "{SHA}";
    }

    public String hash(HashString hashString, String password) {
        return B64ENC.encodeToString(this.md.digest(password.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean needsSeparator() {
        return false;
    }
}

