/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.shiro.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.shiro.impl.ShiroAuthProviderImpl;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;

public class LDAPAuthProvider
extends ShiroAuthProviderImpl {
    public static Realm createRealm(JsonObject config) {
        String systemPassword;
        String systemUsername;
        String contextFactoryClassName;
        String authenticationMechanism;
        String url;
        JndiLdapRealm ldapRealm = new JndiLdapRealm();
        JndiLdapContextFactory factory = new JndiLdapContextFactory();
        String userDNTemplate = config.getString("ldap_user_dn_template");
        if (userDNTemplate != null) {
            ldapRealm.setUserDnTemplate(userDNTemplate);
        }
        if ((url = config.getString("ldap_url")) != null) {
            factory.setUrl(url);
        }
        if ((authenticationMechanism = config.getString("ldap_authentication_mechanism")) != null) {
            factory.setAuthenticationMechanism(authenticationMechanism);
        }
        if ((contextFactoryClassName = config.getString("ldap_context_factory_class_name")) != null) {
            factory.setContextFactoryClassName(contextFactoryClassName);
        }
        boolean poolingEnabled = config.getBoolean("ldap_pooling_enabled", Boolean.valueOf(false));
        factory.setPoolingEnabled(poolingEnabled);
        String referral = config.getString("ldap_referral");
        if (referral != null) {
            factory.setReferral(referral);
        }
        if ((systemUsername = config.getString("ldap_system_username")) != null) {
            factory.setSystemUsername(systemUsername);
        }
        if ((systemPassword = config.getString("ldap_system_password")) != null) {
            factory.setSystemPassword(systemPassword);
        }
        ldapRealm.setContextFactory((LdapContextFactory)factory);
        ldapRealm.init();
        return ldapRealm;
    }

    public LDAPAuthProvider(Vertx vertx, Realm realm) {
        super(vertx, realm);
    }
}

