/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.shiro.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.impl.LDAPAuthProvider;
import io.vertx.ext.auth.shiro.impl.PropertiesAuthProvider;
import io.vertx.ext.auth.shiro.impl.ShiroUser;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;

public class ShiroAuthProviderImpl
implements ShiroAuth {
    private Vertx vertx;
    private SecurityManager securityManager;
    private String rolePrefix = "role:";
    private String realmName;

    public static ShiroAuth create(Vertx vertx, ShiroAuthOptions options) {
        Realm realm;
        switch (options.getType()) {
            case PROPERTIES: {
                realm = PropertiesAuthProvider.createRealm(options.getConfig());
                break;
            }
            case LDAP: {
                realm = LDAPAuthProvider.createRealm(options.getConfig());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid shiro auth realm type: " + (Object)((Object)options.getType()));
            }
        }
        return new ShiroAuthProviderImpl(vertx, realm);
    }

    public ShiroAuthProviderImpl(Vertx vertx, Realm realm) {
        this.vertx = vertx;
        this.securityManager = new DefaultSecurityManager(realm);
        this.realmName = realm.getName();
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
            DefaultSubjectContext subjectContext = new DefaultSubjectContext();
            Subject subject = this.securityManager.createSubject((SubjectContext)subjectContext);
            String username = authInfo.getString("username");
            String password = authInfo.getString("password");
            UsernamePasswordToken token = new UsernamePasswordToken(username, password);
            try {
                subject.login((AuthenticationToken)token);
            }
            catch (AuthenticationException e) {
                throw new VertxException((Throwable)e);
            }
            fut.complete((Object)new ShiroUser(this.vertx, this.securityManager, subject, this.rolePrefix));
        }, resultHandler);
    }

    @Override
    public ShiroAuth setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
        return this;
    }

    Vertx getVertx() {
        return this.vertx;
    }

    SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    String getRealmName() {
        return this.realmName;
    }
}

