/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.camel.impl;

import io.vertx.camel.InboundMapping;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import org.apache.camel.Message;

class CamelHelper {
    private CamelHelper() {
    }

    static DeliveryOptions getDeliveryOptions(Message msg, boolean headerCopy) {
        DeliveryOptions delivery = new DeliveryOptions();
        if (headerCopy && msg.hasHeaders()) {
            msg.getHeaders().entrySet().stream().forEach(entry -> {
                if (entry.getValue() != null) {
                    delivery.addHeader((String)entry.getKey(), entry.getValue().toString());
                }
            });
        }
        return delivery;
    }

    static Object convert(InboundMapping inbound, Message msg) {
        if (inbound.getBodyType() != null) {
            return msg.getBody(inbound.getBodyType());
        }
        Object body = msg.getBody();
        if (body instanceof org.fusesource.hawtbuf.Buffer) {
            return Buffer.buffer((byte[])((org.fusesource.hawtbuf.Buffer)body).toByteArray());
        }
        return body;
    }
}

