/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.converter;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.codegen.converter.AggregatedDataObject;
import io.vertx.test.codegen.converter.ChildInheritingDataObject;
import io.vertx.test.codegen.converter.ChildInheritingDataObjectConverter;
import io.vertx.test.codegen.converter.ChildNotInheritingDataObject;
import io.vertx.test.codegen.converter.ChildNotInheritingDataObjectConverter;
import io.vertx.test.codegen.converter.NoConverterDataObject;
import io.vertx.test.codegen.converter.SetterAdderDataObject;
import io.vertx.test.codegen.converter.SetterAdderDataObjectConverter;
import io.vertx.test.codegen.converter.TestDataObject;
import io.vertx.test.codegen.converter.TestDataObjectConverter;
import io.vertx.test.codegen.converter.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DataObjectTest {
    private static JsonObject toJson(Map<String, Object> map) {
        JsonObject json = new JsonObject();
        map.forEach((arg_0, arg_1) -> ((JsonObject)json).put(arg_0, arg_1));
        return json;
    }

    @Test
    public void testJsonToDataObject() {
        String key = TestUtils.randomAlphaString(10);
        String stringValue = TestUtils.randomAlphaString(20);
        boolean booleanValue = TestUtils.randomBoolean();
        byte byteValue = TestUtils.randomByte();
        short shortValue = TestUtils.randomShort();
        int intValue = TestUtils.randomInt();
        long longValue = TestUtils.randomLong();
        float floatValue = TestUtils.randomFloat();
        double doubleValue = TestUtils.randomDouble();
        char charValue = TestUtils.randomChar();
        Boolean boxedBooleanValue = TestUtils.randomBoolean();
        Byte boxedByteValue = TestUtils.randomByte();
        Short boxedShortValue = TestUtils.randomShort();
        Integer boxedIntValue = TestUtils.randomInt();
        Long boxedLongValue = TestUtils.randomLong();
        Float boxedFloatValue = Float.valueOf(TestUtils.randomFloat());
        Double boxedDoubleValue = TestUtils.randomDouble();
        Character boxedCharValue = Character.valueOf(TestUtils.randomChar());
        AggregatedDataObject aggregatedDataObject = new AggregatedDataObject().setValue(TestUtils.randomAlphaString(20));
        Buffer buffer = TestUtils.randomBuffer(20);
        JsonObject jsonObject = new JsonObject().put("wibble", (Object)TestUtils.randomAlphaString(20));
        JsonArray jsonArray = new JsonArray().add((Object)TestUtils.randomAlphaString(20));
        TimeUnit httpMethod = TimeUnit.values()[TestUtils.randomPositiveInt() % TimeUnit.values().length];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomAlphaString(20));
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomBoolean());
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomInt());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TestUtils.randomAlphaString(20));
        list.add(TestUtils.randomBoolean());
        list.add(TestUtils.randomInt());
        JsonObject json = new JsonObject();
        json.put("stringValue", (Object)stringValue);
        json.put("booleanValue", (Object)booleanValue);
        json.put("byteValue", (Object)byteValue);
        json.put("shortValue", (Object)shortValue);
        json.put("intValue", (Object)intValue);
        json.put("longValue", (Object)longValue);
        json.put("floatValue", (Object)Float.valueOf(floatValue));
        json.put("doubleValue", (Object)doubleValue);
        json.put("charValue", (Object)Character.toString(charValue));
        json.put("boxedBooleanValue", (Object)boxedBooleanValue);
        json.put("boxedByteValue", (Object)boxedByteValue);
        json.put("boxedShortValue", (Object)boxedShortValue);
        json.put("boxedIntValue", (Object)boxedIntValue);
        json.put("boxedLongValue", (Object)boxedLongValue);
        json.put("boxedFloatValue", (Object)boxedFloatValue);
        json.put("boxedDoubleValue", (Object)boxedDoubleValue);
        json.put("boxedCharValue", (Object)Character.toString(boxedCharValue.charValue()));
        json.put("aggregatedDataObject", (Object)aggregatedDataObject.toJson());
        json.put("buffer", (Object)this.toBase64(buffer));
        json.put("jsonObject", (Object)jsonObject);
        json.put("jsonArray", (Object)jsonArray);
        json.put("httpMethod", (Object)httpMethod.toString());
        json.put("stringValues", (Object)new JsonArray().add((Object)stringValue));
        json.put("boxedBooleanValues", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("boxedByteValues", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("boxedShortValues", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("boxedIntValues", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("boxedLongValues", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("boxedFloatValues", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("boxedDoubleValues", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("boxedCharValues", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("aggregatedDataObjects", (Object)new JsonArray().add((Object)aggregatedDataObject.toJson()));
        json.put("buffers", (Object)new JsonArray().add((Object)this.toBase64(buffer)));
        json.put("jsonObjects", (Object)new JsonArray().add((Object)jsonObject));
        json.put("jsonArrays", (Object)new JsonArray().add((Object)jsonArray));
        json.put("httpMethods", (Object)new JsonArray().add((Object)httpMethod.toString()));
        json.put("objects", (Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("stringSet", (Object)new JsonArray().add((Object)stringValue));
        json.put("boxedBooleanSet", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("boxedByteSet", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("boxedShortSet", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("boxedIntSet", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("boxedLongSet", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("boxedFloatSet", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("boxedDoubleSet", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("boxedCharSet", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("aggregatedDataObjectSet", (Object)new JsonArray().add((Object)aggregatedDataObject.toJson()));
        json.put("bufferSet", (Object)new JsonArray().add((Object)this.toBase64(buffer)));
        json.put("jsonObjectSet", (Object)new JsonArray().add((Object)jsonObject));
        json.put("jsonArraySet", (Object)new JsonArray().add((Object)jsonArray));
        json.put("httpMethodSet", (Object)new JsonArray().add((Object)httpMethod.toString()));
        json.put("objectSet", (Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("addedStringValues", (Object)new JsonArray().add((Object)stringValue));
        json.put("addedBooleanValues", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("addedByteValues", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("addedShortValues", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("addedIntValues", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("addedLongValues", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("addedFloatValues", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("addedDoubleValues", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("addedCharValues", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("addedBoxedBooleanValues", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("addedBoxedByteValues", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("addedBoxedShortValues", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("addedBoxedIntValues", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("addedBoxedLongValues", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("addedBoxedFloatValues", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("addedBoxedDoubleValues", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("addedBoxedCharValues", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("addedAggregatedDataObjects", (Object)new JsonArray().add((Object)aggregatedDataObject.toJson()));
        json.put("addedBuffers", (Object)new JsonArray().add((Object)this.toBase64(buffer)));
        json.put("addedJsonObjects", (Object)new JsonArray().add((Object)jsonObject));
        json.put("addedJsonArrays", (Object)new JsonArray().add((Object)jsonArray));
        json.put("addedHttpMethods", (Object)new JsonArray().add((Object)httpMethod.toString()));
        json.put("addedObjects", (Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("stringValueMap", (Object)new JsonObject().put(key, (Object)stringValue));
        json.put("boxedBooleanValueMap", (Object)new JsonObject().put(key, (Object)boxedBooleanValue));
        json.put("boxedByteValueMap", (Object)new JsonObject().put(key, (Object)boxedByteValue));
        json.put("boxedShortValueMap", (Object)new JsonObject().put(key, (Object)boxedShortValue));
        json.put("boxedIntValueMap", (Object)new JsonObject().put(key, (Object)boxedIntValue));
        json.put("boxedLongValueMap", (Object)new JsonObject().put(key, (Object)boxedLongValue));
        json.put("boxedFloatValueMap", (Object)new JsonObject().put(key, (Object)boxedFloatValue));
        json.put("boxedDoubleValueMap", (Object)new JsonObject().put(key, (Object)boxedDoubleValue));
        json.put("boxedCharValueMap", (Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())));
        json.put("aggregatedDataObjectMap", (Object)new JsonObject().put(key, (Object)aggregatedDataObject.toJson()));
        json.put("bufferMap", (Object)new JsonObject().put(key, (Object)this.toBase64(buffer)));
        json.put("jsonObjectMap", (Object)new JsonObject().put(key, (Object)jsonObject));
        json.put("jsonArrayMap", (Object)new JsonObject().put(key, (Object)jsonArray));
        json.put("httpMethodMap", (Object)new JsonObject().put(key, (Object)httpMethod.toString()));
        json.put("objectMap", (Object)DataObjectTest.toJson(map));
        json.put("keyedStringValues", (Object)new JsonObject().put(key, (Object)stringValue));
        json.put("keyedBoxedBooleanValues", (Object)new JsonObject().put(key, (Object)boxedBooleanValue));
        json.put("keyedBoxedByteValues", (Object)new JsonObject().put(key, (Object)boxedByteValue));
        json.put("keyedBoxedShortValues", (Object)new JsonObject().put(key, (Object)boxedShortValue));
        json.put("keyedBoxedIntValues", (Object)new JsonObject().put(key, (Object)boxedIntValue));
        json.put("keyedBoxedLongValues", (Object)new JsonObject().put(key, (Object)boxedLongValue));
        json.put("keyedBoxedFloatValues", (Object)new JsonObject().put(key, (Object)boxedFloatValue));
        json.put("keyedBoxedDoubleValues", (Object)new JsonObject().put(key, (Object)boxedDoubleValue));
        json.put("keyedBoxedCharValues", (Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())));
        json.put("keyedDataObjectValues", (Object)new JsonObject().put(key, (Object)aggregatedDataObject.toJson()));
        json.put("keyedBufferValues", (Object)new JsonObject().put(key, (Object)this.toBase64(buffer)));
        json.put("keyedJsonObjectValues", (Object)new JsonObject().put(key, (Object)jsonObject));
        json.put("keyedJsonArrayValues", (Object)new JsonObject().put(key, (Object)jsonArray));
        json.put("keyedEnumValues", (Object)new JsonObject().put(key, (Object)httpMethod.name()));
        json.put("keyedObjectValues", (Object)DataObjectTest.toJson(map));
        TestDataObject obj = new TestDataObject();
        TestDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, obj);
        Assert.assertEquals((Object)stringValue, (Object)obj.getStringValue());
        Assert.assertEquals((Object)booleanValue, (Object)obj.isBooleanValue());
        Assert.assertEquals((long)byteValue, (long)obj.getByteValue());
        Assert.assertEquals((long)shortValue, (long)obj.getShortValue());
        Assert.assertEquals((long)intValue, (long)obj.getIntValue());
        Assert.assertEquals((long)longValue, (long)obj.getLongValue());
        Assert.assertEquals((float)floatValue, (float)obj.getFloatValue(), (float)0.0f);
        Assert.assertEquals((double)doubleValue, (double)obj.getDoubleValue(), (double)0.0);
        Assert.assertEquals((long)charValue, (long)obj.getCharValue());
        Assert.assertEquals((Object)boxedBooleanValue, (Object)obj.isBoxedBooleanValue());
        Assert.assertEquals((Object)boxedByteValue, (Object)obj.getBoxedByteValue());
        Assert.assertEquals((Object)boxedShortValue, (Object)obj.getBoxedShortValue());
        Assert.assertEquals((Object)boxedIntValue, (Object)obj.getBoxedIntValue());
        Assert.assertEquals((Object)boxedLongValue, (Object)obj.getBoxedLongValue());
        Assert.assertEquals((float)boxedFloatValue.floatValue(), (float)obj.getBoxedFloatValue().floatValue(), (float)0.0f);
        Assert.assertEquals((double)boxedDoubleValue, (double)obj.getBoxedDoubleValue(), (double)0.0);
        Assert.assertEquals((Object)boxedCharValue, (Object)obj.getBoxedCharValue());
        Assert.assertEquals((Object)aggregatedDataObject, (Object)obj.getAggregatedDataObject());
        Assert.assertEquals((Object)buffer, (Object)obj.getBuffer());
        Assert.assertEquals((Object)jsonObject, (Object)obj.getJsonObject());
        Assert.assertEquals((Object)jsonArray, (Object)obj.getJsonArray());
        Assert.assertEquals((Object)((Object)httpMethod), (Object)((Object)obj.getHttpMethod()));
        Assert.assertEquals(Collections.singletonList(stringValue), obj.getStringValues());
        Assert.assertEquals(Collections.singletonList(boxedBooleanValue), obj.getBoxedBooleanValues());
        Assert.assertEquals(Collections.singletonList(boxedByteValue), obj.getBoxedByteValues());
        Assert.assertEquals(Collections.singletonList(boxedShortValue), obj.getBoxedShortValues());
        Assert.assertEquals(Collections.singletonList(boxedIntValue), obj.getBoxedIntValues());
        Assert.assertEquals(Collections.singletonList(boxedLongValue), obj.getBoxedLongValues());
        Assert.assertEquals(Collections.singletonList(boxedFloatValue), obj.getBoxedFloatValues());
        Assert.assertEquals(Collections.singletonList(boxedDoubleValue), obj.getBoxedDoubleValues());
        Assert.assertEquals(Collections.singletonList(boxedCharValue), obj.getBoxedCharValues());
        Assert.assertEquals(Collections.singletonList(aggregatedDataObject), obj.getAggregatedDataObjects());
        Assert.assertEquals(Collections.singletonList(buffer), obj.getBuffers());
        Assert.assertEquals(Collections.singletonList(jsonObject), obj.getJsonObjects());
        Assert.assertEquals(Collections.singletonList(jsonArray), obj.getJsonArrays());
        Assert.assertEquals(Collections.singletonList(httpMethod), obj.getHttpMethods());
        Assert.assertEquals(list, obj.getObjects());
        Assert.assertEquals(Collections.singleton(stringValue), obj.getStringSet());
        Assert.assertEquals(Collections.singleton(boxedBooleanValue), obj.getBoxedBooleanSet());
        Assert.assertEquals(Collections.singleton(boxedByteValue), obj.getBoxedByteSet());
        Assert.assertEquals(Collections.singleton(boxedShortValue), obj.getBoxedShortSet());
        Assert.assertEquals(Collections.singleton(boxedIntValue), obj.getBoxedIntSet());
        Assert.assertEquals(Collections.singleton(boxedLongValue), obj.getBoxedLongSet());
        Assert.assertEquals(Collections.singleton(boxedFloatValue), obj.getBoxedFloatSet());
        Assert.assertEquals(Collections.singleton(boxedDoubleValue), obj.getBoxedDoubleSet());
        Assert.assertEquals(Collections.singleton(boxedCharValue), obj.getBoxedCharSet());
        Assert.assertEquals(Collections.singleton(aggregatedDataObject), obj.getAggregatedDataObjectSet());
        Assert.assertEquals(Collections.singleton(buffer), obj.getBufferSet());
        Assert.assertEquals(Collections.singleton(jsonObject), obj.getJsonObjectSet());
        Assert.assertEquals(Collections.singleton(jsonArray), obj.getJsonArraySet());
        Assert.assertEquals(Collections.singleton(httpMethod), obj.getHttpMethodSet());
        Assert.assertEquals(new LinkedHashSet(list), obj.getObjectSet());
        Assert.assertEquals(Collections.singletonList(stringValue), obj.getAddedStringValues());
        Assert.assertEquals(Collections.singletonList(boxedBooleanValue), obj.getAddedBoxedBooleanValues());
        Assert.assertEquals(Collections.singletonList(boxedByteValue), obj.getAddedBoxedByteValues());
        Assert.assertEquals(Collections.singletonList(boxedShortValue), obj.getAddedBoxedShortValues());
        Assert.assertEquals(Collections.singletonList(boxedIntValue), obj.getAddedBoxedIntValues());
        Assert.assertEquals(Collections.singletonList(boxedLongValue), obj.getAddedBoxedLongValues());
        Assert.assertEquals(Collections.singletonList(boxedFloatValue), obj.getAddedBoxedFloatValues());
        Assert.assertEquals(Collections.singletonList(boxedDoubleValue), obj.getAddedBoxedDoubleValues());
        Assert.assertEquals(Collections.singletonList(boxedCharValue), obj.getAddedBoxedCharValues());
        Assert.assertEquals(Collections.singletonList(aggregatedDataObject), obj.getAddedAggregatedDataObjects());
        Assert.assertEquals(Collections.singletonList(buffer), obj.getAddedBuffers());
        Assert.assertEquals(Collections.singletonList(jsonObject), obj.getAddedJsonObjects());
        Assert.assertEquals(Collections.singletonList(jsonArray), obj.getAddedJsonArrays());
        Assert.assertEquals(Collections.singletonList(httpMethod), obj.getAddedHttpMethods());
        Assert.assertEquals(list, obj.getAddedObjects());
        Assert.assertEquals(Collections.singletonMap(key, stringValue), obj.getStringValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedBooleanValue), obj.getBoxedBooleanValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedByteValue), obj.getBoxedByteValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedShortValue), obj.getBoxedShortValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedIntValue), obj.getBoxedIntValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedLongValue), obj.getBoxedLongValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedFloatValue), obj.getBoxedFloatValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedDoubleValue), obj.getBoxedDoubleValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedCharValue), obj.getBoxedCharValueMap());
        Assert.assertEquals(Collections.singletonMap(key, aggregatedDataObject), obj.getAggregatedDataObjectMap());
        Assert.assertEquals(Collections.singletonMap(key, buffer), obj.getBufferMap());
        Assert.assertEquals(Collections.singletonMap(key, jsonObject), obj.getJsonObjectMap());
        Assert.assertEquals(Collections.singletonMap(key, jsonArray), obj.getJsonArrayMap());
        Assert.assertEquals(Collections.singletonMap(key, httpMethod), obj.getHttpMethodMap());
        Assert.assertEquals(map, obj.getObjectMap());
        Assert.assertEquals(Collections.singletonMap(key, stringValue), obj.getKeyedStringValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedBooleanValue), obj.getKeyedBoxedBooleanValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedByteValue), obj.getKeyedBoxedByteValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedShortValue), obj.getKeyedBoxedShortValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedIntValue), obj.getKeyedBoxedIntValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedLongValue), obj.getKeyedBoxedLongValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedFloatValue), obj.getKeyedBoxedFloatValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedDoubleValue), obj.getKeyedBoxedDoubleValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedCharValue), obj.getKeyedBoxedCharValues());
        Assert.assertEquals(Collections.singletonMap(key, aggregatedDataObject), obj.getKeyedDataObjectValues());
        Assert.assertEquals(Collections.singletonMap(key, buffer), obj.getKeyedBufferValues());
        Assert.assertEquals(Collections.singletonMap(key, jsonObject), obj.getKeyedJsonObjectValues());
        Assert.assertEquals(Collections.singletonMap(key, jsonArray), obj.getKeyedJsonArrayValues());
        Assert.assertEquals(Collections.singletonMap(key, httpMethod), obj.getKeyedEnumValues());
        Assert.assertEquals(map, obj.getObjectMap());
    }

    @Test
    public void testEmptyJsonToDataObject() {
        JsonObject json = new JsonObject();
        TestDataObject obj = new TestDataObject();
        TestDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, obj);
        Assert.assertEquals(null, (Object)obj.getStringValue());
        Assert.assertEquals((Object)false, (Object)obj.isBooleanValue());
        Assert.assertEquals((long)0L, (long)obj.getByteValue());
        Assert.assertEquals((long)0L, (long)obj.getShortValue());
        Assert.assertEquals((long)0L, (long)obj.getIntValue());
        Assert.assertEquals((long)0L, (long)obj.getLongValue());
        Assert.assertEquals((float)0.0f, (float)obj.getFloatValue(), (float)0.0f);
        Assert.assertEquals((double)0.0, (double)obj.getDoubleValue(), (double)0.0);
        Assert.assertEquals((long)0L, (long)obj.getCharValue());
        Assert.assertEquals(null, (Object)obj.isBoxedBooleanValue());
        Assert.assertEquals(null, (Object)obj.getBoxedByteValue());
        Assert.assertEquals(null, (Object)obj.getBoxedShortValue());
        Assert.assertEquals(null, (Object)obj.getBoxedIntValue());
        Assert.assertEquals(null, (Object)obj.getBoxedLongValue());
        Assert.assertEquals(null, (Object)obj.getBoxedFloatValue());
        Assert.assertEquals(null, (Object)obj.getBoxedDoubleValue());
        Assert.assertEquals(null, (Object)obj.getBoxedCharValue());
        Assert.assertEquals(null, (Object)obj.getAggregatedDataObject());
        Assert.assertEquals(null, (Object)obj.getBuffer());
        Assert.assertEquals(null, (Object)obj.getJsonObject());
        Assert.assertEquals(null, (Object)obj.getJsonArray());
        Assert.assertEquals(null, obj.getStringValues());
        Assert.assertEquals(null, obj.getBoxedBooleanValues());
        Assert.assertEquals(null, obj.getBoxedByteValues());
        Assert.assertEquals(null, obj.getBoxedShortValues());
        Assert.assertEquals(null, obj.getBoxedIntValues());
        Assert.assertEquals(null, obj.getBoxedLongValues());
        Assert.assertEquals(null, obj.getBoxedFloatValues());
        Assert.assertEquals(null, obj.getBoxedDoubleValues());
        Assert.assertEquals(null, obj.getBoxedCharValues());
        Assert.assertEquals(null, obj.getAggregatedDataObjects());
        Assert.assertEquals(null, obj.getBuffers());
        Assert.assertEquals(null, obj.getJsonObjects());
        Assert.assertEquals(null, obj.getJsonArrays());
        Assert.assertEquals(null, obj.getHttpMethods());
        Assert.assertEquals(null, obj.getObjects());
        Assert.assertEquals(null, obj.getStringSet());
        Assert.assertEquals(null, obj.getBoxedBooleanSet());
        Assert.assertEquals(null, obj.getBoxedByteSet());
        Assert.assertEquals(null, obj.getBoxedShortSet());
        Assert.assertEquals(null, obj.getBoxedIntSet());
        Assert.assertEquals(null, obj.getBoxedLongSet());
        Assert.assertEquals(null, obj.getBoxedFloatSet());
        Assert.assertEquals(null, obj.getBoxedDoubleSet());
        Assert.assertEquals(null, obj.getBoxedCharSet());
        Assert.assertEquals(null, obj.getAggregatedDataObjectSet());
        Assert.assertEquals(null, obj.getBufferSet());
        Assert.assertEquals(null, obj.getJsonObjectSet());
        Assert.assertEquals(null, obj.getJsonArraySet());
        Assert.assertEquals(null, obj.getHttpMethodSet());
        Assert.assertEquals(null, obj.getObjectSet());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedStringValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedBooleanValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedByteValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedShortValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedIntValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedLongValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedFloatValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedDoubleValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedCharValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedAggregatedDataObjects());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBuffers());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedJsonObjects());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedJsonArrays());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedHttpMethods());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedObjects());
        Assert.assertEquals(null, obj.getStringValueMap());
        Assert.assertEquals(null, obj.getBoxedBooleanValueMap());
        Assert.assertEquals(null, obj.getBoxedByteValueMap());
        Assert.assertEquals(null, obj.getBoxedShortValueMap());
        Assert.assertEquals(null, obj.getBoxedIntValueMap());
        Assert.assertEquals(null, obj.getBoxedLongValueMap());
        Assert.assertEquals(null, obj.getBoxedFloatValueMap());
        Assert.assertEquals(null, obj.getBoxedDoubleValueMap());
        Assert.assertEquals(null, obj.getBoxedCharValueMap());
        Assert.assertEquals(null, obj.getAggregatedDataObjectMap());
        Assert.assertEquals(null, obj.getBufferMap());
        Assert.assertEquals(null, obj.getJsonObjectMap());
        Assert.assertEquals(null, obj.getJsonArrayMap());
        Assert.assertEquals(null, obj.getHttpMethodMap());
        Assert.assertEquals(null, obj.getObjectMap());
    }

    @Test
    public void testDataObjectToJson() {
        String key = TestUtils.randomAlphaString(10);
        String stringValue = TestUtils.randomAlphaString(20);
        boolean booleanValue = TestUtils.randomBoolean();
        byte byteValue = TestUtils.randomByte();
        short shortValue = TestUtils.randomShort();
        int intValue = TestUtils.randomInt();
        long longValue = TestUtils.randomLong();
        float floatValue = TestUtils.randomFloat();
        double doubleValue = TestUtils.randomDouble();
        char charValue = TestUtils.randomChar();
        Boolean boxedBooleanValue = TestUtils.randomBoolean();
        Byte boxedByteValue = TestUtils.randomByte();
        Short boxedShortValue = TestUtils.randomShort();
        Integer boxedIntValue = TestUtils.randomInt();
        Long boxedLongValue = TestUtils.randomLong();
        Float boxedFloatValue = Float.valueOf(TestUtils.randomFloat());
        Double boxedDoubleValue = TestUtils.randomDouble();
        Character boxedCharValue = Character.valueOf(TestUtils.randomChar());
        AggregatedDataObject aggregatedDataObject = new AggregatedDataObject().setValue(TestUtils.randomAlphaString(20));
        Buffer buffer = TestUtils.randomBuffer(20);
        JsonObject jsonObject = new JsonObject().put("wibble", (Object)TestUtils.randomAlphaString(20));
        JsonArray jsonArray = new JsonArray().add((Object)TestUtils.randomAlphaString(20));
        TimeUnit httpMethod = TimeUnit.values()[TestUtils.randomPositiveInt() % TimeUnit.values().length];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomAlphaString(20));
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomBoolean());
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomInt());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TestUtils.randomAlphaString(20));
        list.add(TestUtils.randomBoolean());
        list.add(TestUtils.randomInt());
        TestDataObject obj = new TestDataObject();
        obj.setStringValue(stringValue);
        obj.setBooleanValue(booleanValue);
        obj.setByteValue(byteValue);
        obj.setShortValue(shortValue);
        obj.setIntValue(intValue);
        obj.setLongValue(longValue);
        obj.setFloatValue(floatValue);
        obj.setDoubleValue(doubleValue);
        obj.setCharValue(charValue);
        obj.setBoxedBooleanValue(boxedBooleanValue);
        obj.setBoxedByteValue(boxedByteValue);
        obj.setBoxedShortValue(boxedShortValue);
        obj.setBoxedIntValue(boxedIntValue);
        obj.setBoxedLongValue(boxedLongValue);
        obj.setBoxedFloatValue(boxedFloatValue);
        obj.setBoxedDoubleValue(boxedDoubleValue);
        obj.setBoxedCharValue(boxedCharValue);
        obj.setAggregatedDataObject(aggregatedDataObject);
        obj.setBuffer(buffer);
        obj.setJsonObject(jsonObject);
        obj.setJsonArray(jsonArray);
        obj.setHttpMethod(httpMethod);
        obj.setStringValues(Collections.singletonList(stringValue));
        obj.setBoxedBooleanValues(Collections.singletonList(boxedBooleanValue));
        obj.setBoxedByteValues(Collections.singletonList(boxedByteValue));
        obj.setBoxedShortValues(Collections.singletonList(boxedShortValue));
        obj.setBoxedIntValues(Collections.singletonList(boxedIntValue));
        obj.setBoxedLongValues(Collections.singletonList(boxedLongValue));
        obj.setBoxedFloatValues(Collections.singletonList(boxedFloatValue));
        obj.setBoxedDoubleValues(Collections.singletonList(boxedDoubleValue));
        obj.setBoxedCharValues(Collections.singletonList(boxedCharValue));
        obj.setAggregatedDataObjects(Collections.singletonList(aggregatedDataObject));
        obj.setBuffers(Collections.singletonList(buffer));
        obj.setJsonObjects(Collections.singletonList(jsonObject));
        obj.setJsonArrays(Collections.singletonList(jsonArray));
        obj.setHttpMethods(Collections.singletonList(httpMethod));
        obj.setObjects(list);
        obj.setStringValueMap(Collections.singletonMap(key, stringValue));
        obj.setStringSet(Collections.singleton(stringValue));
        obj.setBoxedBooleanSet(Collections.singleton(boxedBooleanValue));
        obj.setBoxedByteSet(Collections.singleton(boxedByteValue));
        obj.setBoxedShortSet(Collections.singleton(boxedShortValue));
        obj.setBoxedIntSet(Collections.singleton(boxedIntValue));
        obj.setBoxedLongSet(Collections.singleton(boxedLongValue));
        obj.setBoxedFloatSet(Collections.singleton(boxedFloatValue));
        obj.setBoxedDoubleSet(Collections.singleton(boxedDoubleValue));
        obj.setBoxedCharSet(Collections.singleton(boxedCharValue));
        obj.setAggregatedDataObjectSet(Collections.singleton(aggregatedDataObject));
        obj.setBufferSet(Collections.singleton(buffer));
        obj.setJsonObjectSet(Collections.singleton(jsonObject));
        obj.setJsonArraySet(Collections.singleton(jsonArray));
        obj.setHttpMethodSet(Collections.singleton(httpMethod));
        obj.setObjectSet(new LinkedHashSet<Object>(list));
        obj.setBoxedBooleanValueMap(Collections.singletonMap(key, boxedBooleanValue));
        obj.setBoxedByteValueMap(Collections.singletonMap(key, boxedByteValue));
        obj.setBoxedShortValueMap(Collections.singletonMap(key, boxedShortValue));
        obj.setBoxedIntValueMap(Collections.singletonMap(key, boxedIntValue));
        obj.setBoxedLongValueMap(Collections.singletonMap(key, boxedLongValue));
        obj.setBoxedFloatValueMap(Collections.singletonMap(key, boxedFloatValue));
        obj.setBoxedDoubleValueMap(Collections.singletonMap(key, boxedDoubleValue));
        obj.setBoxedCharValueMap(Collections.singletonMap(key, boxedCharValue));
        obj.setAggregatedDataObjectMap(Collections.singletonMap(key, aggregatedDataObject));
        obj.setBufferMap(Collections.singletonMap(key, buffer));
        obj.setJsonObjectMap(Collections.singletonMap(key, jsonObject));
        obj.setJsonArrayMap(Collections.singletonMap(key, jsonArray));
        obj.setHttpMethodMap(Collections.singletonMap(key, httpMethod));
        obj.setObjectMap(map);
        obj.addKeyedStringValue(key, stringValue);
        obj.addKeyedBoxedBooleanValue(key, boxedBooleanValue);
        obj.addKeyedBoxedByteValue(key, boxedByteValue);
        obj.addKeyedBoxedShortValue(key, boxedShortValue);
        obj.addKeyedBoxedIntValue(key, boxedIntValue);
        obj.addKeyedBoxedLongValue(key, boxedLongValue);
        obj.addKeyedBoxedFloatValue(key, boxedFloatValue);
        obj.addKeyedBoxedDoubleValue(key, boxedDoubleValue);
        obj.addKeyedBoxedCharValue(key, boxedCharValue);
        obj.addKeyedDataObjectValue(key, aggregatedDataObject);
        obj.addKeyedBufferValue(key, buffer);
        obj.addKeyedJsonObjectValue(key, jsonObject);
        obj.addKeyedJsonArrayValue(key, jsonArray);
        obj.addKeyedEnumValue(key, httpMethod);
        map.forEach(obj::addKeyedObjectValue);
        HashMap<String, Object> json = new HashMap<String, Object>();
        TestDataObjectConverter.toJson(obj, json);
        Assert.assertEquals((Object)stringValue, json.get("stringValue"));
        Assert.assertEquals((Object)booleanValue, json.get("booleanValue"));
        Assert.assertEquals((long)byteValue, (long)((Byte)json.get("byteValue")).byteValue());
        Assert.assertEquals((long)shortValue, (long)((Short)json.get("shortValue")).shortValue());
        Assert.assertEquals((long)intValue, (long)((Integer)json.get("intValue")).intValue());
        Assert.assertEquals((long)longValue, (long)((Long)json.get("longValue")));
        Assert.assertEquals((double)floatValue, (double)((Float)json.get("floatValue")).floatValue(), (double)0.001);
        Assert.assertEquals((double)doubleValue, (double)((Double)json.get("doubleValue")), (double)0.001);
        Assert.assertEquals((Object)Character.toString(charValue), json.get("charValue"));
        Assert.assertEquals((Object)boxedBooleanValue, json.get("boxedBooleanValue"));
        Assert.assertEquals((long)boxedByteValue.byteValue(), (long)((Byte)json.get("boxedByteValue")).byteValue());
        Assert.assertEquals((long)boxedShortValue.shortValue(), (long)((Short)json.get("boxedShortValue")).shortValue());
        Assert.assertEquals((Object)boxedIntValue, json.get("boxedIntValue"));
        Assert.assertEquals((Object)boxedLongValue, json.get("boxedLongValue"));
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)json.get("boxedFloatValue")).floatValue(), (double)0.001);
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)json.get("boxedDoubleValue")), (double)0.001);
        Assert.assertEquals((Object)Character.toString(boxedCharValue.charValue()), json.get("boxedCharValue"));
        Assert.assertEquals((Object)aggregatedDataObject.toJson(), json.get("aggregatedDataObject"));
        Assert.assertEquals((Object)buffer, (Object)Buffer.buffer((byte[])Base64.getDecoder().decode((String)json.get("buffer"))));
        Assert.assertEquals((Object)jsonObject, json.get("jsonObject"));
        Assert.assertEquals((Object)jsonArray, json.get("jsonArray"));
        Assert.assertEquals((Object)httpMethod.name(), json.get("httpMethod"));
        Assert.assertEquals((Object)new JsonArray().add((Object)stringValue), json.get("stringValues"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedBooleanValue), json.get("boxedBooleanValues"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedByteValue), json.get("boxedByteValues"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedShortValue), json.get("boxedShortValues"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedIntValue), json.get("boxedIntValues"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedLongValue), json.get("boxedLongValues"));
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedFloatValues")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonArray)json.get("boxedFloatValues")).getValue(0)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedDoubleValues")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonArray)json.get("boxedDoubleValues")).getValue(0)), (double)0.001);
        Assert.assertEquals((Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())), json.get("boxedCharValues"));
        Assert.assertEquals((Object)new JsonArray().add((Object)aggregatedDataObject.toJson()), json.get("aggregatedDataObjects"));
        Assert.assertEquals((Object)Base64.getEncoder().encodeToString(buffer.getBytes()), (Object)((JsonArray)json.get("buffers")).getValue(0));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonObject), json.get("jsonObjects"));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonArray), json.get("jsonArrays"));
        Assert.assertEquals((Object)new JsonArray().add((Object)httpMethod.name()), json.get("httpMethods"));
        Assert.assertEquals((Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)), json.get("objects"));
        Assert.assertEquals((Object)new JsonArray().add((Object)stringValue), json.get("stringSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedBooleanValue), json.get("boxedBooleanSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedByteValue), json.get("boxedByteSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedShortValue), json.get("boxedShortSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedIntValue), json.get("boxedIntSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedLongValue), json.get("boxedLongSet"));
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedFloatSet")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonArray)json.get("boxedFloatSet")).getValue(0)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedDoubleSet")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonArray)json.get("boxedDoubleSet")).getValue(0)), (double)0.001);
        Assert.assertEquals((Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())), json.get("boxedCharSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)aggregatedDataObject.toJson()), json.get("aggregatedDataObjectSet"));
        Assert.assertEquals((Object)Base64.getEncoder().encodeToString(buffer.getBytes()), (Object)((JsonArray)json.get("bufferSet")).getValue(0));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonObject), json.get("jsonObjectSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonArray), json.get("jsonArraySet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)httpMethod.name()), json.get("httpMethodSet"));
        Assert.assertEquals((Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)), json.get("objectSet"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)stringValue), json.get("stringValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedBooleanValue), json.get("boxedBooleanValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedByteValue), json.get("boxedByteValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedShortValue), json.get("boxedShortValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedIntValue), json.get("boxedIntValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedLongValue), json.get("boxedLongValueMap"));
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("boxedFloatValueMap")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonObject)json.get("boxedFloatValueMap")).getValue(key)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("boxedDoubleValueMap")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonObject)json.get("boxedDoubleValueMap")).getValue(key)), (double)0.001);
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())), json.get("boxedCharValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)aggregatedDataObject.toJson()), json.get("aggregatedDataObjectMap"));
        Assert.assertEquals((Object)Base64.getEncoder().encodeToString(buffer.getBytes()), (Object)((JsonObject)json.get("bufferMap")).getValue(key));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonObject), json.get("jsonObjectMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonArray), json.get("jsonArrayMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)httpMethod.name()), json.get("httpMethodMap"));
        Assert.assertEquals((Object)DataObjectTest.toJson(map), json.get("objectMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)stringValue), json.get("keyedStringValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedBooleanValue), json.get("keyedBoxedBooleanValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedByteValue), json.get("keyedBoxedByteValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedShortValue), json.get("keyedBoxedShortValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedIntValue), json.get("keyedBoxedIntValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedLongValue), json.get("keyedBoxedLongValues"));
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("keyedBoxedFloatValues")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonObject)json.get("keyedBoxedFloatValues")).getValue(key)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("keyedBoxedDoubleValues")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonObject)json.get("keyedBoxedDoubleValues")).getValue(key)), (double)0.001);
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())), json.get("keyedBoxedCharValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)aggregatedDataObject.toJson()), json.get("keyedDataObjectValues"));
        Assert.assertEquals((Object)Base64.getEncoder().encodeToString(buffer.getBytes()), (Object)((JsonObject)json.get("keyedBufferValues")).getValue(key));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonObject), json.get("keyedJsonObjectValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonArray), json.get("keyedJsonArrayValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)httpMethod.name()), json.get("keyedEnumValues"));
        Assert.assertEquals((Object)DataObjectTest.toJson(map), json.get("keyedObjectValues"));
    }

    @Test
    public void testEmptyDataObjectToJson() {
        TestDataObject obj = new TestDataObject();
        HashMap<String, Object> json = new HashMap<String, Object>();
        TestDataObjectConverter.toJson(obj, json);
        Assert.assertEquals(null, json.get("stringValue"));
        Assert.assertEquals((Object)false, json.get("booleanValue"));
        Assert.assertEquals((long)0L, (long)((Byte)json.get("byteValue")).byteValue());
        Assert.assertEquals((long)0L, (long)((Short)json.get("shortValue")).shortValue());
        Assert.assertEquals((long)0L, (long)((Integer)json.get("intValue")).intValue());
        Assert.assertEquals((long)0L, (long)((Long)json.get("longValue")));
        Assert.assertEquals((float)0.0f, (float)((Float)json.get("floatValue")).floatValue(), (float)0.0f);
        Assert.assertEquals((double)0.0, (double)((Double)json.get("doubleValue")), (double)0.0);
        Assert.assertEquals((Object)Character.toString('\u0000'), json.get("charValue"));
        Assert.assertEquals(null, json.get("boxedBooleanValue"));
        Assert.assertEquals(null, json.get("boxedByteValue"));
        Assert.assertEquals(null, json.get("boxedShortValue"));
        Assert.assertEquals(null, json.get("boxedIntValue"));
        Assert.assertEquals(null, json.get("boxedLongValue"));
        Assert.assertEquals(null, json.get("boxedFloatValue"));
        Assert.assertEquals(null, json.get("boxedDoubleValue"));
        Assert.assertEquals(null, json.get("boxedCharValue"));
        Assert.assertEquals(null, json.get("aggregatedDataObject"));
        Assert.assertEquals(null, json.get("buffer"));
        Assert.assertEquals(null, json.get("jsonObject"));
        Assert.assertEquals(null, json.get("jsonArray"));
        Assert.assertEquals(null, json.get("httpMethod"));
        Assert.assertEquals(null, json.get("stringValues"));
        Assert.assertEquals(null, json.get("boxedBooleanValues"));
        Assert.assertEquals(null, json.get("boxedByteValues"));
        Assert.assertEquals(null, json.get("boxedShortValues"));
        Assert.assertEquals(null, json.get("boxedIntValues"));
        Assert.assertEquals(null, json.get("boxedLongValues"));
        Assert.assertEquals(null, json.get("boxedFloatValues"));
        Assert.assertEquals(null, json.get("boxedDoubleValues"));
        Assert.assertEquals(null, json.get("boxedCharValues"));
        Assert.assertEquals(null, json.get("aggregatedDataObjects"));
        Assert.assertEquals(null, json.get("buffers"));
        Assert.assertEquals(null, json.get("jsonObjects"));
        Assert.assertEquals(null, json.get("jsonArrays"));
        Assert.assertEquals(null, json.get("httpMethods"));
        Assert.assertEquals(null, json.get("objects"));
        Assert.assertEquals(null, json.get("stringSet"));
        Assert.assertEquals(null, json.get("boxedBooleanSet"));
        Assert.assertEquals(null, json.get("boxedByteSet"));
        Assert.assertEquals(null, json.get("boxedShortSet"));
        Assert.assertEquals(null, json.get("boxedIntSet"));
        Assert.assertEquals(null, json.get("boxedLongSet"));
        Assert.assertEquals(null, json.get("boxedFloatSet"));
        Assert.assertEquals(null, json.get("boxedDoubleSet"));
        Assert.assertEquals(null, json.get("boxedCharSet"));
        Assert.assertEquals(null, json.get("aggregatedDataObjectSet"));
        Assert.assertEquals(null, json.get("bufferSet"));
        Assert.assertEquals(null, json.get("jsonObjectSet"));
        Assert.assertEquals(null, json.get("jsonArraySet"));
        Assert.assertEquals(null, json.get("httpMethodSet"));
        Assert.assertEquals(null, json.get("objectSet"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedStringValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedBooleanValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedByteValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedShortValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedIntValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedLongValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedFloatValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedDoubleValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedCharValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedAggregatedDataObjects"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBuffers"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedJsonObjects"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedJsonArrays"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedHttpMethods"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedObjects"));
        Assert.assertEquals(null, json.get("stringValueMap"));
        Assert.assertEquals(null, json.get("boxedBooleanValueMap"));
        Assert.assertEquals(null, json.get("boxedByteValueMap"));
        Assert.assertEquals(null, json.get("boxedShortValueMap"));
        Assert.assertEquals(null, json.get("boxedIntValueMap"));
        Assert.assertEquals(null, json.get("boxedLongValueMap"));
        Assert.assertEquals(null, json.get("boxedFloatValueMap"));
        Assert.assertEquals(null, json.get("boxedDoubleValueMap"));
        Assert.assertEquals(null, json.get("boxedCharValueMap"));
        Assert.assertEquals(null, json.get("aggregatedDataObjectMap"));
        Assert.assertEquals(null, json.get("bufferMap"));
        Assert.assertEquals(null, json.get("jsonObjectMap"));
        Assert.assertEquals(null, json.get("jsonArrayMap"));
        Assert.assertEquals(null, json.get("httpMethodMap"));
        Assert.assertEquals(null, json.get("objectMap"));
    }

    @Test
    public void testNoConverters() {
        try {
            NoConverterDataObject.class.getClassLoader().loadClass(NoConverterDataObject.class.getName() + "Converter");
            Assert.fail((String)"Was not expecting a converter to be generated");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testInherit() {
        ChildInheritingDataObject obj = new ChildInheritingDataObject();
        JsonObject expectedJson = new JsonObject();
        expectedJson.put("childProperty", (Object)"childProperty_value");
        expectedJson.put("parentProperty", (Object)"parentProperty_value");
        ChildInheritingDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)expectedJson, obj);
        Assert.assertEquals((Object)"childProperty_value", (Object)obj.getChildProperty());
        Assert.assertEquals((Object)"parentProperty_value", (Object)obj.getParentProperty());
        JsonObject json = new JsonObject();
        ChildInheritingDataObjectConverter.toJson(obj, json);
        Assert.assertEquals((Object)expectedJson, (Object)json);
    }

    @Test
    public void testNotInherit() {
        ChildNotInheritingDataObject obj = new ChildNotInheritingDataObject();
        JsonObject expectedJson = new JsonObject();
        expectedJson.put("childProperty", (Object)"childProperty_value");
        expectedJson.put("parentProperty", (Object)"parentProperty_value");
        ChildNotInheritingDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)expectedJson, obj);
        Assert.assertEquals((Object)"childProperty_value", (Object)obj.getChildProperty());
        Assert.assertEquals(null, (Object)obj.getParentProperty());
        JsonObject json = new JsonObject();
        ChildNotInheritingDataObjectConverter.toJson(obj, json);
        expectedJson.remove("parentProperty");
        Assert.assertEquals((Object)expectedJson, (Object)json);
    }

    private String toBase64(Buffer buffer) {
        return Base64.getEncoder().encodeToString(buffer.getBytes());
    }

    @Test
    public void testPreferSetterToAdder() {
        SetterAdderDataObject obj = new SetterAdderDataObject();
        SetterAdderDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)new JsonObject().put("values", (Object)new JsonArray().add((Object)"first").add((Object)"second")), obj);
        Assert.assertEquals(Arrays.asList("first", "second"), obj.getValues());
        Assert.assertEquals((long)1L, (long)obj.sets);
        Assert.assertEquals((long)0L, (long)obj.adds);
    }
}

