/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.writer;

import io.vertx.codegen.writer.CodeWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class CodeWriterTest {
    @Test
    public void testUnderlyingWriter() {
        StringWriter w = new StringWriter();
        CodeWriter writer = new CodeWriter((Writer)w);
        Assert.assertSame((Object)w, (Object)writer.writer());
    }

    @Test
    public void testIndentation() {
        CodeWriter writer = this.assertWriter(w -> w.codeln("line 1").indent().codeln("line 2").codeln("line 3").indent().codeln("line 4").unindent().unindent().code("line 5"), "line 1\n  line 2\n  line 3\n    line 4\nline 5");
        Assert.assertEquals((Object)"", (Object)writer.indentation());
        Assert.assertEquals((long)2L, (long)writer.indentSize());
    }

    @Test
    public void testIndentationFactor() {
        CodeWriter writer = this.assertWriter(w -> {
            w.indentSize(4);
            w.codeln("line 1").indent().codeln("line 2").codeln("line 3").indent().codeln("line 4").unindent().unindent().code("line 5");
        }, "line 1\n    line 2\n    line 3\n        line 4\nline 5");
        Assert.assertEquals((Object)"", (Object)writer.indentation());
        Assert.assertEquals((long)4L, (long)writer.indentSize());
    }

    @Test
    public void testStmt() {
        CodeWriter writer = this.assertWriter(w -> w.stmt("line 1").indent().stmt("line 2").stmt("line 3").indent().stmt("line 4").unindent().unindent().stmt("line 5"), "line 1;\n  line 2;\n  line 3;\n    line 4;\nline 5;\n");
    }

    @Test
    public void testJavaImport() {
        CodeWriter writer = this.assertWriter(w -> w.javaImport("io.vertx.test.codegen.utils.CodeWriterTest"), "import io.vertx.test.codegen.utils.CodeWriterTest;\n");
    }

    @Test
    public void testArray() {
        this.assertWriter(w -> w.writeSeq(Stream.of(2, 4, 1, 5, 6, 1).map(Object::toString), ", "), "2, 4, 1, 5, 6, 1");
    }

    @Test
    public void testCodeForceNewLine() {
        this.assertWriter(w -> {
            w.indent().print("foo");
            w.code("bar");
        }, "  foo\n  bar");
    }

    @Test
    public void testPrint1() {
        this.assertWriter(w -> w.indent().print("foo"), "  foo");
    }

    @Test
    public void testPrint2() {
        this.assertWriter(w -> {
            w.indent().print("foo");
            w.print("bar");
        }, "  foobar");
    }

    @Test
    public void testPrintNewLine() {
        this.assertWriter(w -> w.indent().print("foo\nbar"), "  foo\n  bar");
    }

    private CodeWriter assertWriter(Consumer<CodeWriter> codeToExecute, String expectedOutput) {
        StringWriter w = new StringWriter();
        CodeWriter codeWriter = new CodeWriter((Writer)w);
        codeToExecute.accept(codeWriter);
        Assert.assertEquals((Object)expectedOutput, (Object)w.toString());
        return codeWriter;
    }
}

