/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.EventListOptions;
import java.util.Base64;
import java.util.Map;

public class EventListOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, EventListOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "blockingOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setBlockingOptions(new BlockingQueryOptions((JsonObject)member.getValue()));
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(EventListOptions obj, JsonObject json) {
        EventListOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(EventListOptions obj, Map<String, Object> json) {
        if (obj.getBlockingOptions() != null) {
            json.put("blockingOptions", obj.getBlockingOptions().toJson());
        }
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
    }
}

