/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryConverter;
import io.vertx.ext.consul.impl.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@DataObject(generateConverter=true)
public class ServiceEntry {
    private Node node;
    private Service service;
    private List<Check> checks;

    public ServiceEntry() {
    }

    public ServiceEntry(ServiceEntry other) {
        this.node = other.node;
        this.service = other.service;
        this.checks = other.checks;
    }

    public ServiceEntry(JsonObject json) {
        ServiceEntryConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        ServiceEntryConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public CheckStatus aggregatedStatus() {
        return Utils.aggregateCheckStatus(this.checks.stream().map(Check::getStatus).collect(Collectors.toList()));
    }

    public Node getNode() {
        return this.node;
    }

    public Service getService() {
        return this.service;
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    public ServiceEntry setNode(Node node) {
        this.node = node;
        return this;
    }

    public ServiceEntry setService(Service service) {
        this.service = service;
        return this;
    }

    public ServiceEntry setChecks(List<Check> checks) {
        this.checks = checks;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceEntry entry = (ServiceEntry)o;
        if (this.node != null ? !this.node.equals(entry.node) : entry.node != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(entry.service) : entry.service != null) {
            return false;
        }
        return this.checks != null ? this.sorted().equals(entry.sorted()) : entry.checks == null;
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.checks != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<Check> sorted() {
        ArrayList<Check> sorted = null;
        if (this.checks != null) {
            sorted = new ArrayList<Check>(this.checks);
            sorted.sort(Comparator.comparing(Check::getId));
        }
        return sorted;
    }
}

