/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceList;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class ServiceListConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ServiceList obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "index": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIndex(((Number)member.getValue()).longValue());
                    break;
                }
                case "list": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Service> list = new ArrayList<Service>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Service((JsonObject)item));
                        }
                    });
                    obj.setList(list);
                }
            }
        }
    }

    public static void toJson(ServiceList obj, JsonObject json) {
        ServiceListConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ServiceList obj, Map<String, Object> json) {
        json.put("index", obj.getIndex());
        if (obj.getList() != null) {
            JsonArray array = new JsonArray();
            obj.getList().forEach(item -> array.add((Object)item.toJson()));
            json.put("list", array);
        }
    }
}

