/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.ServiceOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServiceOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ServiceOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "address": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAddress((String)member.getValue());
                    break;
                }
                case "checkListOptions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<CheckOptions> list = new ArrayList<CheckOptions>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new CheckOptions((JsonObject)item));
                        }
                    });
                    obj.setCheckListOptions(list);
                    break;
                }
                case "checkOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCheckOptions(new CheckOptions((JsonObject)member.getValue()));
                    break;
                }
                case "id": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setId((String)member.getValue());
                    break;
                }
                case "meta": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setMeta(map);
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "tags": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<CheckOptions> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((CheckOptions)((Object)((String)item)));
                        }
                    });
                    obj.setTags(list);
                }
            }
        }
    }

    public static void toJson(ServiceOptions obj, JsonObject json) {
        ServiceOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ServiceOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getAddress() != null) {
            json.put("address", obj.getAddress());
        }
        if (obj.getCheckListOptions() != null) {
            array = new JsonArray();
            obj.getCheckListOptions().forEach(item -> array.add((Object)item.toJson()));
            json.put("checkListOptions", array);
        }
        if (obj.getCheckOptions() != null) {
            json.put("checkOptions", obj.getCheckOptions().toJson());
        }
        if (obj.getId() != null) {
            json.put("id", obj.getId());
        }
        if (obj.getMeta() != null) {
            JsonObject map = new JsonObject();
            obj.getMeta().forEach((key, value) -> map.put(key, value));
            json.put("meta", map);
        }
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        json.put("port", obj.getPort());
        if (obj.getTags() != null) {
            array = new JsonArray();
            obj.getTags().forEach(item -> array.add(item));
            json.put("tags", array);
        }
    }
}

