/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.pool.Pool;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ConnectionManager {
    private final int maxWaitQueueSize;
    private final HttpClientMetrics metrics;
    private final HttpClientImpl client;
    private final Map<Channel, HttpClientConnection> connectionMap = new ConcurrentHashMap<Channel, HttpClientConnection>();
    private final Map<EndpointKey, Endpoint> endpointMap = new ConcurrentHashMap<EndpointKey, Endpoint>();
    private final HttpVersion version;
    private final long maxSize;
    private long timerID;

    ConnectionManager(HttpClientImpl client, HttpClientMetrics metrics, HttpVersion version, long maxSize, int maxWaitQueueSize) {
        this.client = client;
        this.maxWaitQueueSize = maxWaitQueueSize;
        this.metrics = metrics;
        this.maxSize = maxSize;
        this.version = version;
    }

    synchronized void start() {
        long period = this.client.getOptions().getPoolCleanerPeriod();
        this.timerID = period > 0L ? this.client.getVertx().setTimer(period, id -> this.checkExpired(period)) : -1L;
    }

    private synchronized void checkExpired(long period) {
        long timestamp = System.currentTimeMillis();
        this.endpointMap.values().forEach(e -> ((Endpoint)e).pool.closeIdle(timestamp));
        this.timerID = this.client.getVertx().setTimer(period, id -> this.checkExpired(period));
    }

    void getConnection(ContextInternal ctx, String peerHost, boolean ssl, int port, String host, Handler<AsyncResult<HttpClientConnection>> handler) {
        Object metric;
        Endpoint endpoint;
        EndpointKey key = new EndpointKey(ssl, port, peerHost, host);
        do {
            endpoint = this.endpointMap.computeIfAbsent(key, targetAddress -> {
                int maxPoolSize = Math.max(this.client.getOptions().getMaxPoolSize(), this.client.getOptions().getHttp2MaxPoolSize());
                Object metric = this.metrics != null ? this.metrics.createEndpoint(host, port, maxPoolSize) : null;
                HttpChannelConnector connector = new HttpChannelConnector(this.client, metric, this.version, ssl, peerHost, host, port);
                Pool<HttpClientConnection> pool = new Pool<HttpClientConnection>(connector, this.maxWaitQueueSize, connector.weight(), this.maxSize, v -> {
                    if (this.metrics != null) {
                        this.metrics.closeEndpoint(host, port, metric);
                    }
                    this.endpointMap.remove(key);
                }, this.connectionMap::put, this.connectionMap::remove, false);
                return new Endpoint(pool, metric);
            });
            metric = this.metrics != null ? this.metrics.enqueueRequest(endpoint.metric) : null;
        } while (!endpoint.pool.getConnection(ctx, ar -> {
            if (ar.succeeded()) {
                HttpClientConnection conn = (HttpClientConnection)ar.result();
                if (this.metrics != null) {
                    this.metrics.dequeueRequest(endpoint.metric, metric);
                }
                handler.handle(Future.succeededFuture(conn));
            } else {
                if (this.metrics != null) {
                    this.metrics.dequeueRequest(endpoint.metric, metric);
                }
                handler.handle(Future.failedFuture(ar.cause()));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.timerID >= 0L) {
                this.client.getVertx().cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.endpointMap.clear();
        for (HttpClientConnection conn : this.connectionMap.values()) {
            conn.close();
        }
    }

    class Endpoint {
        private final Pool<HttpClientConnection> pool;
        private final Object metric;

        public Endpoint(Pool<HttpClientConnection> pool, Object metric) {
            this.pool = pool;
            this.metric = metric;
        }
    }

    private static final class EndpointKey {
        private final boolean ssl;
        private final int port;
        private final String peerHost;
        private final String host;

        EndpointKey(boolean ssl, int port, String peerHost, String host) {
            if (host == null) {
                throw new NullPointerException("No null host");
            }
            if (peerHost == null) {
                throw new NullPointerException("No null peer host");
            }
            this.ssl = ssl;
            this.peerHost = peerHost;
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointKey that = (EndpointKey)o;
            return this.ssl == that.ssl && this.port == that.port && this.peerHost.equals(that.peerHost) && this.host.equals(that.host);
        }

        public int hashCode() {
            int result = this.ssl ? 1 : 0;
            result = 31 * result + this.peerHost.hashCode();
            result = 31 * result + this.host.hashCode();
            result = 31 * result + this.port;
            return result;
        }
    }
}

