/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public abstract class ConnectionBase {
    public static final VertxException CLOSED_EXCEPTION = new VertxException("Connection was closed", true);
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    private static final int MAX_REGION_SIZE = 0x100000;
    private final VoidChannelPromise voidPromise;
    protected final VertxInternal vertx;
    protected final ChannelHandlerContext chctx;
    protected final ContextInternal context;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private boolean read;
    private boolean needsFlush;
    private int writeInProgress;
    private Object metric;

    protected ConnectionBase(VertxInternal vertx, ChannelHandlerContext chctx, ContextInternal context) {
        this.vertx = vertx;
        this.chctx = chctx;
        this.context = context;
        this.voidPromise = new VoidChannelPromise(chctx.channel(), false);
    }

    public void fail(Throwable error) {
        this.handler().fail(error);
    }

    public VertxHandler handler() {
        return (VertxHandler)this.chctx.handler();
    }

    protected final synchronized void endReadAndFlush() {
        if (this.read) {
            this.read = false;
            if (this.needsFlush && this.writeInProgress == 0) {
                this.needsFlush = false;
                this.chctx.flush();
            }
        }
    }

    private void write(Object msg, ChannelPromise promise) {
        if (this.read || this.writeInProgress > 0) {
            this.needsFlush = true;
            this.chctx.write(msg, promise);
        } else {
            this.needsFlush = false;
            this.chctx.writeAndFlush(msg, promise);
        }
    }

    public synchronized void writeToChannel(Object msg, ChannelPromise promise) {
        if (this.chctx.executor().inEventLoop() && this.writeInProgress == 0) {
            this.write(msg, promise);
        } else {
            this.queueForWrite(msg, promise);
        }
    }

    private void queueForWrite(Object msg, ChannelPromise promise) {
        ++this.writeInProgress;
        this.context.runOnContext(v -> {
            ConnectionBase connectionBase = this;
            synchronized (connectionBase) {
                --this.writeInProgress;
                this.write(msg, promise);
            }
        });
    }

    public void writeToChannel(Object obj) {
        this.writeToChannel(obj, (ChannelPromise)this.voidPromise);
    }

    public boolean isNotWritable() {
        return !this.chctx.channel().isWritable();
    }

    public void close() {
        this.endReadAndFlush();
        this.chctx.channel().close();
    }

    public synchronized ConnectionBase closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    public synchronized ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    protected synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public void doPause() {
        this.chctx.channel().config().setAutoRead(false);
    }

    public void doResume() {
        this.chctx.channel().config().setAutoRead(true);
    }

    public void doSetWriteQueueMaxSize(int size) {
        ChannelConfig config = this.chctx.channel().config();
        config.setWriteBufferWaterMark(new WriteBufferWaterMark(size / 2, size));
    }

    protected final void checkContext() {
        if (this.context != this.vertx.getContext()) {
            throw new IllegalStateException("Wrong context!");
        }
    }

    public final Channel channel() {
        return this.chctx.channel();
    }

    public final ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    public final ContextInternal getContext() {
        return this.context;
    }

    public final synchronized void metric(Object metric) {
        this.metric = metric;
    }

    public final synchronized Object metric() {
        return this.metric;
    }

    public abstract NetworkMetrics metrics();

    protected synchronized void handleException(Throwable t) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.exceptionOccurred(this.metric, this.remoteAddress(), t);
        }
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        } else if (log.isDebugEnabled()) {
            log.error((Object)t.getMessage(), t);
        } else {
            log.error(t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClosed() {
        Handler<Void> handler;
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            NetworkMetrics metrics = this.metrics();
            if (metrics != null && metrics instanceof TCPMetrics) {
                ((TCPMetrics)metrics).disconnected(this.metric(), this.remoteAddress());
            }
            handler = this.closeHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    protected abstract void handleInterestedOpsChanged();

    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future) {
        if (future != null) {
            future.addListener(channelFuture -> this.context.executeFromIO(v -> {
                if (completionHandler != null) {
                    if (channelFuture.isSuccess()) {
                        completionHandler.handle(Future.succeededFuture());
                    } else {
                        completionHandler.handle(Future.failedFuture(channelFuture.cause()));
                    }
                } else if (!channelFuture.isSuccess()) {
                    this.handleException(channelFuture.cause());
                }
            }));
        }
    }

    protected boolean supportsFileRegion() {
        return !this.isSSL();
    }

    public void reportBytesRead(long numberOfBytes) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.bytesRead(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    public void reportBytesWritten(long numberOfBytes) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.bytesWritten(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    public boolean isSSL() {
        return this.chctx.pipeline().get(SslHandler.class) != null;
    }

    private void sendFileRegion(RandomAccessFile file, long offset, long length, ChannelPromise writeFuture) {
        if (length < 0x100000L) {
            this.writeToChannel(new DefaultFileRegion(file.getChannel(), offset, length), writeFuture);
        } else {
            ChannelPromise promise = this.chctx.newPromise();
            DefaultFileRegion region = new DefaultFileRegion(file.getChannel(), offset, 0x100000L);
            region.retain();
            this.writeToChannel(region, promise);
            promise.addListener(future -> {
                if (future.isSuccess()) {
                    this.sendFileRegion(file, offset + 0x100000L, length - 0x100000L, writeFuture);
                } else {
                    future.cause().printStackTrace();
                    writeFuture.setFailure(future.cause());
                }
            });
        }
    }

    protected ChannelFuture sendFile(RandomAccessFile raf, long offset, long length) throws IOException {
        ChannelPromise writeFuture = this.chctx.newPromise();
        if (!this.supportsFileRegion()) {
            this.writeToChannel(new ChunkedFile(raf, offset, length, 8192), writeFuture);
        } else {
            this.sendFileRegion(raf, offset, length, writeFuture);
        }
        if (writeFuture != null) {
            writeFuture.addListener(fut -> raf.close());
        } else {
            raf.close();
        }
        return writeFuture;
    }

    public boolean isSsl() {
        return this.chctx.pipeline().get(SslHandler.class) != null;
    }

    public SSLSession sslSession() {
        if (this.isSSL()) {
            ChannelHandlerContext sslHandlerContext = this.chctx.pipeline().context("ssl");
            assert (sslHandlerContext != null);
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession();
        }
        return null;
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.isSSL()) {
            ChannelHandlerContext sslHandlerContext = this.chctx.pipeline().context(SslHandler.class);
            assert (sslHandlerContext != null);
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession().getPeerCertificateChain();
        }
        return null;
    }

    public String indicatedServerName() {
        if (this.chctx.channel().hasAttr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR)) {
            return (String)this.chctx.channel().attr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR).get();
        }
        return null;
    }

    public ChannelPromise channelFuture() {
        return this.chctx.newPromise();
    }

    public String remoteName() {
        InetSocketAddress addr = (InetSocketAddress)this.chctx.channel().remoteAddress();
        if (addr == null) {
            return null;
        }
        return addr.getHostString();
    }

    public SocketAddress remoteAddress() {
        InetSocketAddress addr = (InetSocketAddress)this.chctx.channel().remoteAddress();
        if (addr == null) {
            return null;
        }
        return new SocketAddressImpl(addr);
    }

    public SocketAddress localAddress() {
        InetSocketAddress addr = (InetSocketAddress)this.chctx.channel().localAddress();
        if (addr == null) {
            return null;
        }
        return new SocketAddressImpl(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleRead(Object msg) {
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            this.read = true;
        }
        this.handleMessage(msg);
    }

    public void handleMessage(Object msg) {
    }
}

