/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.List;
import java.util.Map;

public class MessageImpl<U, V>
implements Message<V> {
    private static final Logger log = LoggerFactory.getLogger(MessageImpl.class);
    protected MessageCodec<U, V> messageCodec;
    protected final EventBusImpl bus;
    public final boolean src;
    protected String address;
    protected String replyAddress;
    protected MultiMap headers;
    protected U sentBody;
    protected V receivedBody;
    protected boolean send;
    protected Handler<AsyncResult<Void>> writeHandler;

    public MessageImpl(boolean src, EventBusImpl bus) {
        this.bus = bus;
        this.src = src;
    }

    public MessageImpl(String address, String replyAddress, MultiMap headers, U sentBody, MessageCodec<U, V> messageCodec, boolean send, boolean src, EventBusImpl bus, Handler<AsyncResult<Void>> writeHandler) {
        this.messageCodec = messageCodec;
        this.address = address;
        this.replyAddress = replyAddress;
        this.headers = headers;
        this.sentBody = sentBody;
        this.send = send;
        this.bus = bus;
        this.src = src;
        this.writeHandler = writeHandler;
    }

    protected MessageImpl(MessageImpl<U, V> other, boolean src) {
        this.bus = other.bus;
        this.address = other.address;
        this.replyAddress = other.replyAddress;
        this.messageCodec = other.messageCodec;
        this.src = src;
        if (other.headers != null) {
            List<Map.Entry<String, String>> entries = other.headers.entries();
            this.headers = new CaseInsensitiveHeaders();
            for (Map.Entry<String, String> entry : entries) {
                this.headers.add(entry.getKey(), entry.getValue());
            }
        }
        if (other.sentBody != null) {
            this.sentBody = other.sentBody;
            this.receivedBody = this.messageCodec.transform(other.sentBody);
        }
        this.send = other.send;
        this.writeHandler = other.writeHandler;
    }

    public MessageImpl<U, V> copyBeforeReceive(boolean src) {
        return new MessageImpl<U, V>(this, src);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHeaders();
        }
        return this.headers;
    }

    @Override
    public V body() {
        if (this.receivedBody == null && this.sentBody != null) {
            this.receivedBody = this.messageCodec.transform(this.sentBody);
        }
        return this.receivedBody;
    }

    @Override
    public String replyAddress() {
        return this.replyAddress;
    }

    @Override
    public void fail(int failureCode, String message) {
        this.reply(new ReplyException(ReplyFailure.RECIPIENT_FAILURE, failureCode, message));
    }

    @Override
    public void reply(Object message) {
        this.replyAndRequest(message, new DeliveryOptions(), null);
    }

    @Override
    public <R> void replyAndRequest(Object message, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.replyAndRequest(message, new DeliveryOptions(), replyHandler);
    }

    @Override
    public void reply(Object message, DeliveryOptions options) {
        this.replyAndRequest(message, options, null);
    }

    @Override
    public <R> void replyAndRequest(Object message, DeliveryOptions options, Handler<AsyncResult<Message<R>>> replyHandler) {
        if (this.replyAddress != null) {
            MessageImpl reply = this.bus.createMessage(true, this.src, this.replyAddress, options.getHeaders(), message, options.getCodecName(), null);
            this.bus.sendReply(reply, this, options, replyHandler);
        }
    }

    @Override
    public boolean isSend() {
        return this.send;
    }

    public void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
    }

    public Handler<AsyncResult<Void>> writeHandler() {
        return this.writeHandler;
    }

    public MessageCodec<U, V> codec() {
        return this.messageCodec;
    }

    protected boolean isLocal() {
        return true;
    }
}

