/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Starter;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

abstract class AbstractContext
implements ContextInternal {
    private static final String THREAD_CHECKS_PROP_NAME = "vertx.threadChecks";
    private static final boolean THREAD_CHECKS = Boolean.getBoolean("vertx.threadChecks");
    private static FastThreadLocal<Holder> holderLocal = new FastThreadLocal<Holder>(){

        protected Holder initialValue() {
            return new Holder();
        }
    };

    AbstractContext() {
    }

    static Context context() {
        Thread current = Thread.currentThread();
        if (current instanceof VertxThread) {
            return ((VertxThread)((Object)current)).context();
        }
        if (current instanceof FastThreadLocalThread) {
            return ((Holder)AbstractContext.holderLocal.get()).ctx;
        }
        return null;
    }

    abstract void executeAsync(Handler<Void> var1);

    abstract <T> void execute(T var1, Handler<T> var2);

    @Override
    public abstract boolean isEventLoopContext();

    @Override
    public boolean isWorkerContext() {
        return !this.isEventLoopContext();
    }

    @Override
    public final void executeFromIO(Handler<Void> task) {
        this.executeFromIO(null, task);
    }

    @Override
    public final void schedule(Handler<Void> task) {
        this.schedule(null, task);
    }

    @Override
    public final void dispatch(Handler<Void> task) {
        this.dispatch(null, task);
    }

    @Override
    public final ContextInternal beginDispatch() {
        Thread th = Thread.currentThread();
        ContextInternal prev = th instanceof VertxThread ? ((VertxThread)((Object)th)).beginDispatch(this) : this.beginNettyThreadDispatch(th);
        if (!VertxThread.DISABLE_TCCL) {
            th.setContextClassLoader(this.classLoader());
        }
        return prev;
    }

    private ContextInternal beginNettyThreadDispatch(Thread th) {
        if (th instanceof FastThreadLocalThread) {
            Holder holder = (Holder)holderLocal.get();
            ContextInternal prev = holder.ctx;
            if (!ContextImpl.DISABLE_TIMINGS) {
                if (holder.checker == null) {
                    BlockedThreadChecker checker;
                    holder.checker = checker = this.owner().blockedThreadChecker();
                    holder.maxExecTime = this.owner().maxEventLoopExecTime();
                    holder.maxExecTimeUnit = this.owner().maxEventLoopExecTimeUnit();
                    checker.registerThread(th, holder);
                }
                if (holder.ctx == null) {
                    holder.startTime = System.nanoTime();
                }
            }
            holder.ctx = this;
            return prev;
        }
        throw new IllegalStateException("Uh oh! context executing with wrong thread! " + th);
    }

    @Override
    public final void endDispatch(ContextInternal prev) {
        Thread th = Thread.currentThread();
        if (!VertxThread.DISABLE_TCCL) {
            th.setContextClassLoader(prev != null ? prev.classLoader() : null);
        }
        if (th instanceof VertxThread) {
            ((VertxThread)((Object)th)).endDispatch(prev);
        } else {
            this.endNettyThreadDispatch(th, prev);
        }
    }

    private void endNettyThreadDispatch(Thread th, ContextInternal prev) {
        if (th instanceof FastThreadLocalThread) {
            Holder holder = (Holder)holderLocal.get();
            holder.ctx = prev;
            if (!ContextImpl.DISABLE_TIMINGS && holder.ctx == null) {
                holder.startTime = 0L;
            }
        } else {
            throw new IllegalStateException("Uh oh! context executing with wrong thread! " + th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> void dispatch(T arg, Handler<T> task) {
        ContextInternal prev = this.beginDispatch();
        try {
            task.handle(arg);
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    @Override
    public final <T> void executeFromIO(T value, Handler<T> task) {
        if (THREAD_CHECKS) {
            this.checkEventLoopThread();
        }
        this.execute(value, task);
    }

    private void checkEventLoopThread() {
        Thread current = Thread.currentThread();
        if (!(current instanceof FastThreadLocalThread)) {
            throw new IllegalStateException("Expected to be on Vert.x thread, but actually on: " + current);
        }
        if (current instanceof VertxThread && ((VertxThread)((Object)current)).isWorker()) {
            throw new IllegalStateException("Event delivered on unexpected worker thread " + current);
        }
    }

    @Override
    public final void runOnContext(Handler<Void> task) {
        try {
            this.executeAsync(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public final List<String> processArgs() {
        List<String> processArgument = VertxCommandLauncher.getProcessArguments();
        return processArgument != null ? processArgument : Starter.PROCESS_ARGS;
    }

    @Override
    public final <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    @Override
    public final ContextInternal duplicate() {
        return this.duplicate(null);
    }

    @Override
    public final <T> T get(String key) {
        return (T)this.contextData().get(key);
    }

    @Override
    public final void put(String key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    public final boolean remove(String key) {
        return this.contextData().remove(key) != null;
    }

    @Override
    public final <T> T getLocal(String key) {
        return (T)this.localContextData().get(key);
    }

    @Override
    public final void putLocal(String key, Object value) {
        this.localContextData().put(key, value);
    }

    @Override
    public final boolean removeLocal(String key) {
        return this.localContextData().remove(key) != null;
    }

    static class Holder
    implements BlockedThreadChecker.Task {
        BlockedThreadChecker checker;
        ContextInternal ctx;
        long startTime = 0L;
        long maxExecTime = 2000000000L;
        TimeUnit maxExecTimeUnit = VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME_UNIT;

        Holder() {
        }

        @Override
        public long startTime() {
            return this.startTime;
        }

        @Override
        public long maxExecTime() {
            return this.maxExecTime;
        }

        @Override
        public TimeUnit maxExecTimeUnit() {
            return this.maxExecTimeUnit;
        }
    }
}

