/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.NoStackTraceThrowable;

class FutureImpl<T>
implements Promise<T>,
Future<T> {
    private boolean failed;
    private boolean succeeded;
    private Handler<AsyncResult<T>> handler;
    private T result;
    private Throwable throwable;

    FutureImpl() {
    }

    @Override
    public synchronized T result() {
        return this.result;
    }

    @Override
    public synchronized Throwable cause() {
        return this.throwable;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public synchronized boolean failed() {
        return this.failed;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.failed || this.succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
        boolean callHandler;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            callHandler = this.isComplete();
            if (!callHandler) {
                this.handler = handler;
            }
        }
        if (callHandler) {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public synchronized Handler<AsyncResult<T>> getHandler() {
        return this.handler;
    }

    @Override
    public void complete(T result) {
        if (!this.tryComplete(result)) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    @Override
    public void complete() {
        if (!this.tryComplete()) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(Throwable cause) {
        if (!this.tryFail(cause)) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(String failureMessage) {
        if (!this.tryFail(failureMessage)) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryComplete(T result) {
        Handler<AsyncResult<T>> h;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded || this.failed) {
                return false;
            }
            this.result = result;
            this.succeeded = true;
            h = this.handler;
            this.handler = null;
        }
        if (h != null) {
            h.handle(this);
        }
        return true;
    }

    @Override
    public boolean tryComplete() {
        return this.tryComplete(null);
    }

    @Override
    public void handle(Future<T> ar) {
        if (ar.succeeded()) {
            this.complete(ar.result());
        } else {
            this.fail(ar.cause());
        }
    }

    @Override
    public void handle(AsyncResult<T> asyncResult) {
        if (asyncResult.succeeded()) {
            this.complete(asyncResult.result());
        } else {
            this.fail(asyncResult.cause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryFail(Throwable cause) {
        Handler<AsyncResult<T>> h;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded || this.failed) {
                return false;
            }
            this.throwable = cause != null ? cause : new NoStackTraceThrowable(null);
            this.failed = true;
            h = this.handler;
            this.handler = null;
        }
        if (h != null) {
            h.handle(this);
        }
        return true;
    }

    @Override
    public boolean tryFail(String failureMessage) {
        return this.tryFail(new NoStackTraceThrowable(failureMessage));
    }

    @Override
    public Future<T> future() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded) {
                return "Future{result=" + this.result + "}";
            }
            if (this.failed) {
                return "Future{cause=" + this.throwable.getMessage() + "}";
            }
            return "Future{unresolved}";
        }
    }
}

