/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.VertxFactory;

public class VertxFactoryImpl
implements VertxFactory {
    @Override
    public Vertx vertx() {
        return this.vertx(new VertxOptions());
    }

    @Override
    public Vertx vertx(VertxOptions options) {
        return this.vertx(options, Transport.transport(options.getPreferNativeTransport()));
    }

    @Override
    public Vertx vertx(VertxOptions options, Transport transport) {
        if (options.getEventBusOptions().isClustered()) {
            throw new IllegalArgumentException("Please use Vertx.clusteredVertx() to create a clustered Vert.x instance");
        }
        return VertxImpl.vertx(options, transport);
    }

    @Override
    public void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        this.clusteredVertx(options, Transport.transport(options.getPreferNativeTransport()), resultHandler);
    }

    @Override
    public void clusteredVertx(VertxOptions options, Transport transport, Handler<AsyncResult<Vertx>> resultHandler) {
        options.getEventBusOptions().setClustered(true);
        VertxImpl.clusteredVertx(options, transport, resultHandler);
    }

    @Override
    public Context context() {
        return AbstractContext.context();
    }
}

