/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.spi.json.JsonCodec;
import java.util.Base64;
import java.util.Map;

public class PfxOptionsConverter
implements JsonCodec<PfxOptions, JsonObject> {
    public static final PfxOptionsConverter INSTANCE = new PfxOptionsConverter();

    @Override
    public JsonObject encode(PfxOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public PfxOptions decode(JsonObject value) {
        return value != null ? new PfxOptions(value) : null;
    }

    @Override
    public Class<PfxOptions> getTargetClass() {
        return PfxOptions.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PfxOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPath((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue(Buffer.buffer(Base64.getDecoder().decode((String)member.getValue())));
                }
            }
        }
    }

    static void toJson(PfxOptions obj, JsonObject json) {
        PfxOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(PfxOptions obj, Map<String, Object> json) {
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getPath() != null) {
            json.put("path", obj.getPath());
        }
        if (obj.getValue() != null) {
            json.put("value", Base64.getEncoder().encodeToString(obj.getValue().getBytes()));
        }
    }
}

