/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.clientconnection.Endpoint;
import io.vertx.core.spi.metrics.ClientMetrics;

abstract class ClientHttpEndpointBase<C>
extends Endpoint<C> {
    private final Object metric;
    private final int port;
    private final String host;
    private final ClientMetrics metrics;

    ClientHttpEndpointBase(ClientMetrics metrics, int port, String host, Object metric, Runnable dispose) {
        super(dispose);
        this.port = port;
        this.host = host;
        this.metric = metric;
        this.metrics = metrics;
    }

    @Override
    public final void requestConnection(ContextInternal ctx, Handler<AsyncResult<C>> handler) {
        if (this.metrics != null) {
            Object metric = this.metrics != null ? this.metrics.enqueueRequest() : null;
            Handler<AsyncResult<C>> next = handler;
            handler = ar -> {
                if (this.metrics != null) {
                    this.metrics.dequeueRequest(metric);
                }
                next.handle((AsyncResult<C>)ar);
            };
        }
        this.requestConnection2(ctx, handler);
    }

    protected abstract void requestConnection2(ContextInternal var1, Handler<AsyncResult<C>> var2);

    @Override
    protected void dispose() {
        if (this.metrics != null) {
            this.metrics.close();
        }
    }
}

