/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.clientconnection;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;

public abstract class Endpoint<C> {
    private final Runnable dispose;
    private boolean closed;
    private boolean disposed;
    private long pendingRequestCount;
    private long refCount;

    public Endpoint(Runnable dispose) {
        this.dispose = dispose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnection(ContextInternal ctx, Handler<AsyncResult<C>> handler) {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            if (this.disposed) {
                return false;
            }
            ++this.pendingRequestCount;
        }
        this.requestConnection(ctx, ar -> {
            boolean dispose;
            Endpoint endpoint = this;
            synchronized (endpoint) {
                --this.pendingRequestCount;
                dispose = this.checkDispose();
            }
            if (dispose) {
                this.disposeInternal();
            }
            handler.handle((AsyncResult<C>)ar);
        });
        return true;
    }

    public abstract void requestConnection(ContextInternal var1, Handler<AsyncResult<C>> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incRefCount() {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            ++this.refCount;
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decRefCount() {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            --this.refCount;
            if (!this.checkDispose()) {
                return false;
            }
        }
        this.disposeInternal();
        return true;
    }

    private void disposeInternal() {
        this.dispose.run();
        this.dispose();
    }

    private boolean checkDispose() {
        if (!this.disposed && this.refCount == 0L && this.pendingRequestCount == 0L) {
            this.disposed = true;
            return true;
        }
        return false;
    }

    protected void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Endpoint endpoint = this;
        synchronized (endpoint) {
            if (this.closed) {
                throw new IllegalStateException();
            }
            this.closed = true;
        }
    }
}

