/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.OutputUnitConverter;
import io.vertx.json.schema.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@DataObject(generateConverter=true)
public class OutputUnit {
    private Boolean valid;
    private String keyword;
    private String keywordLocation;
    private String instanceLocation;
    private String error;
    private List<OutputUnit> errors;
    private List<OutputUnit> annotations;

    public OutputUnit() {
        this.valid = true;
    }

    public OutputUnit(JsonObject json) {
        OutputUnitConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public OutputUnit(boolean valid) {
        this.valid = valid;
    }

    public OutputUnit(String instanceLocation, String keyword, String keywordLocation, String error) {
        this.instanceLocation = instanceLocation;
        this.keyword = keyword;
        this.keywordLocation = keywordLocation;
        this.error = error;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public OutputUnit setValid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public OutputUnit setKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public String getKeywordLocation() {
        return this.keywordLocation;
    }

    public OutputUnit setKeywordLocation(String keywordLocation) {
        this.keywordLocation = keywordLocation;
        return this;
    }

    public String getInstanceLocation() {
        return this.instanceLocation;
    }

    public OutputUnit setInstanceLocation(String instanceLocation) {
        this.instanceLocation = instanceLocation;
        return this;
    }

    public String getError() {
        return this.error;
    }

    public OutputUnit setError(String error) {
        this.error = error;
        return this;
    }

    public List<OutputUnit> getErrors() {
        return this.errors;
    }

    public OutputUnit setErrors(List<OutputUnit> errors) {
        this.errors = errors;
        return this;
    }

    public OutputUnit addError(OutputUnit error) {
        if (this.errors == null) {
            this.errors = new ArrayList<OutputUnit>();
            this.valid = false;
        }
        this.errors.add(error);
        return this;
    }

    @GenIgnore
    public OutputUnit addErrors(List<OutputUnit> errors) {
        if (this.errors == null) {
            this.errors = new ArrayList<OutputUnit>();
            this.valid = false;
        }
        this.errors.addAll(errors);
        return this;
    }

    public List<OutputUnit> getAnnotations() {
        return this.annotations;
    }

    public OutputUnit setAnnotations(List<OutputUnit> annotations) {
        this.annotations = annotations;
        return this;
    }

    public OutputUnit addAnnotation(OutputUnit annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<OutputUnit>();
        }
        this.annotations.add(annotation);
        return this;
    }

    @GenIgnore
    public OutputUnit addAnnotations(List<OutputUnit> annotations) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<OutputUnit>();
        }
        this.annotations.addAll(annotations);
        return this;
    }

    @GenIgnore
    public ValidationException toException(Object input) {
        return new ValidationException(this.error + ": { errors: " + this.formatExceptions(this.errors) + ", annotations: " + this.formatExceptions(this.annotations) + "}", this.keyword, input, true){};
    }

    private String formatExceptions(List<OutputUnit> units) {
        if (units == null) {
            return "[]";
        }
        return "[" + units.stream().filter(Objects::nonNull).map(OutputUnit::toString).collect(Collectors.joining(", ")) + "]";
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OutputUnitConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

