/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorFactory;

public abstract class BaseSingleSchemaValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Object itemsSchema = schema.getValue(this.getKeyword());
            BaseSingleSchemaValidator validator = this.instantiate(parent);
            validator.setSchema(parser.parse(itemsSchema, scope.append(this.getKeyword()), (MutableStateValidator)validator));
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for " + this.getKeyword() + " keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null " + this.getKeyword() + " keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey(this.getKeyword());
    }

    protected abstract BaseSingleSchemaValidator instantiate(MutableStateValidator var1);

    protected abstract String getKeyword();
}

