/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.JsonUtil;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RequiredValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator validator) {
        try {
            JsonArray keys = (JsonArray)schema.getValue("required");
            return new RequiredValidator(new HashSet<String>(keys.getList()));
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for enum keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null enum keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("required");
    }

    public static class RequiredValidator
    extends BaseSyncValidator {
        private final Set<String> requiredKeys;

        public RequiredValidator(Set<String> requiredKeys) {
            this.requiredKeys = requiredKeys;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            Object o = JsonUtil.unwrap(in);
            if (o instanceof Map) {
                Map obj = (Map)o;
                for (String k : this.requiredKeys) {
                    if (obj.containsKey(k)) continue;
                    throw ValidationException.create("provided object should contain property " + k, "required", in);
                }
            }
        }
    }
}

