/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.json.schema.Schema;
import io.vertx.json.schema.common.SchemaInternal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Stream;

class RouterNode {
    private SchemaInternal schema;
    private final Map<String, RouterNode> childs;

    public RouterNode() {
        this(null);
    }

    public RouterNode(SchemaInternal schema) {
        this.schema = schema;
        this.childs = new HashMap<String, RouterNode>();
    }

    public void setSchema(SchemaInternal schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Map<String, RouterNode> getChilds() {
        return this.childs;
    }

    public Stream<RouterNode> flattened() {
        return this.flattenedList().stream();
    }

    public Stream<RouterNode> reverseFlattened() {
        List<RouterNode> output = this.flattenedList();
        Collections.reverse(output);
        return output.stream();
    }

    private List<RouterNode> flattenedList() {
        Stack<RouterNode> nodesToScan = new Stack<RouterNode>();
        nodesToScan.push(this);
        ArrayList<RouterNode> output = new ArrayList<RouterNode>();
        while (!nodesToScan.isEmpty()) {
            RouterNode next = (RouterNode)nodesToScan.pop();
            if (output.contains(next)) continue;
            next.childs.values().forEach(nodesToScan::push);
            output.add(next);
        }
        return output;
    }
}

