/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URL {
    private static final Pattern URL_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private String scheme;
    private String authority;
    private String path;
    private String query;
    private String fragment;
    private static final String genDelims = ":?#@/";
    private static final String subDelims = "!$&'()*+,;=";
    private static final String unreserved = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
    private static final String okChars = ":?#@/!$&'()*+,;=0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~%";

    public URL(String url) {
        this(url, true);
    }

    private URL(String url, boolean strict) {
        Matcher matcher;
        if (strict) {
            if (url == null) {
                throw new NullPointerException("Url isn't valid: null");
            }
            Matcher matcher2 = URL_PATTERN.matcher(URL.escape(url));
            if (!matcher2.matches()) {
                throw new IllegalArgumentException("Url isn't valid: " + url);
            }
            this.scheme = matcher2.group(2);
            this.authority = matcher2.group(4);
            this.path = matcher2.group(5);
            this.query = matcher2.group(7);
            this.fragment = matcher2.group(9);
            if (this.scheme == null) {
                throw new IllegalStateException("(strict) url isn't valid: " + url);
            }
            if (this.authority == null) {
                switch (this.scheme) {
                    case "http": 
                    case "https": 
                    case "ws": 
                    case "wss": 
                    case "ftp": {
                        throw new IllegalStateException("(strict) url isn't valid: " + url);
                    }
                }
            }
            if (this.authority != null && this.path != null && !this.path.startsWith("/")) {
                this.path = "/" + this.path;
            }
        } else if (url != null && url.length() > 0 && (matcher = URL_PATTERN.matcher(URL.escape(url))).matches()) {
            this.scheme = matcher.group(2);
            this.authority = matcher.group(4);
            this.path = matcher.group(5);
            this.query = matcher.group(7);
            this.fragment = matcher.group(9);
        }
        if (this.authority == null && "".equals(this.path) && (this.query != null || this.fragment != null)) {
            this.path = null;
        }
    }

    public URL(String url, String base) {
        this(url, base == null || base.length() == 0 ? null : new URL(base, true));
    }

    public URL(String url, URL base) {
        URL uri = new URL(url, base == null);
        if (base != null) {
            this.scheme = base.scheme;
            this.authority = base.authority;
            this.path = base.path;
            this.query = base.query;
            this.fragment = base.fragment;
        }
        if (uri.scheme != null) {
            this.scheme = uri.scheme;
            this.authority = null;
            this.path = null;
            this.query = null;
            this.fragment = null;
        }
        if (uri.authority != null) {
            this.authority = uri.authority;
            this.path = "/";
            this.query = null;
            this.fragment = null;
        }
        if (uri.path != null) {
            int sep;
            this.path = uri.path.startsWith("/") ? uri.path : (this.path != null ? ((sep = this.path.lastIndexOf(47)) != -1 ? this.path.substring(0, sep + 1) + uri.path : (this.authority != null ? "/" + uri.path : uri.path)) : uri.path);
            this.query = null;
            this.fragment = null;
        }
        if (uri.query != null) {
            this.query = uri.query;
            this.fragment = null;
        }
        if (uri.fragment != null) {
            this.fragment = uri.fragment;
        }
    }

    public String scheme() {
        if (this.scheme == null || this.scheme.length() == 0) {
            return "";
        }
        return this.scheme + ":";
    }

    public String authority() {
        if (this.authority == null || this.authority.length() == 0) {
            return "";
        }
        return this.authority;
    }

    public String path() {
        if (this.path == null || this.path.length() == 0) {
            return "";
        }
        return this.path;
    }

    public String query() {
        if (this.query == null || this.query.length() == 0) {
            return "";
        }
        return "?" + this.query;
    }

    public String fragment() {
        if (this.fragment == null || this.fragment.length() == 0) {
            return "";
        }
        return "#" + this.fragment;
    }

    public URL anchor(String fragment) {
        if (fragment != null) {
            if (fragment.length() == 0) {
                fragment = null;
            } else {
                if (fragment.startsWith("#")) {
                    fragment = fragment.substring(1);
                }
                if (fragment.length() > 0) {
                    fragment = URL.escape(fragment);
                }
            }
        }
        this.fragment = fragment;
        return this;
    }

    public String href() {
        return (this.scheme == null || this.scheme.length() == 0 ? "" : this.scheme + ":") + (this.authority == null ? "" : "//" + this.authority) + (this.path == null ? "" : this.path) + (this.query == null ? "" : "?" + this.query) + (this.fragment == null ? "" : "#" + this.fragment);
    }

    private static String escape(String p) {
        byte[] bytes;
        StringBuilder encoded = new StringBuilder(p.length());
        for (byte aByte : bytes = p.getBytes(StandardCharsets.UTF_8)) {
            if (okChars.indexOf(aByte) >= 0) {
                encoded.append((char)aByte);
                continue;
            }
            encoded.append('%').append(Integer.toHexString(Byte.toUnsignedInt(aByte)).toUpperCase(Locale.ROOT));
        }
        return encoded.toString();
    }

    public String toString() {
        return this.href();
    }
}

